/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.echarts;

import edu.hm.hafner.echarts.Palette;
import edu.hm.hafner.echarts.PieChartModel;
import edu.hm.hafner.echarts.PieData;
import edu.hm.hafner.util.Ensure;
import java.util.function.Function;

public class PercentagePieChart {
    public PieChartModel create(int percentage) {
        return this.createWithPaletteMapper(percentage, this::computeColor);
    }

    public PieChartModel createWithPaletteMapper(int percentage, Function<Integer, Palette> colorMapper) {
        return this.createMode(percentage, colorMapper.apply(percentage).getNormal());
    }

    public PieChartModel createWithStringMapper(int percentage, Function<Integer, String> colorMapper) {
        return this.createMode(percentage, colorMapper.apply(percentage));
    }

    private PieChartModel createMode(int percentage, String actualColorValue) {
        Ensure.that((percentage < 0 || percentage > 100 ? 1 : 0) != 0).isFalse("Percentage %s must be in interval [0,100]", new Object[]{percentage});
        PieChartModel model = new PieChartModel("Percentage");
        model.add(new PieData("Filled", percentage), actualColorValue);
        model.add(new PieData("NotFilled", 100 - percentage), Palette.GRAY);
        return model;
    }

    private Palette computeColor(int percentage) {
        if (percentage < 50) {
            return Palette.RED;
        }
        if (percentage < 80) {
            return Palette.YELLOW;
        }
        return Palette.GREEN;
    }
}

