/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.impl.configurators;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.ExtensionList;
import io.jenkins.plugins.casc.BaseConfigurator;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.ConfiguratorException;
import io.jenkins.plugins.casc.model.CNode;
import io.jenkins.plugins.casc.model.Mapping;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class ExtensionConfigurator<T>
extends BaseConfigurator<T> {
    private final Class<T> target;

    public ExtensionConfigurator(Class<T> clazz) {
        this.target = clazz;
    }

    @Override
    public Class<T> getTarget() {
        return this.target;
    }

    @Override
    protected T instance(Mapping mapping, ConfigurationContext context) throws ConfiguratorException {
        ExtensionList list = Jenkins.get().getExtensionList(this.target);
        if (list.size() != 1) {
            throw new ConfiguratorException("Expected a unique instance of extension " + this.target);
        }
        return (T)list.get(0);
    }

    @Override
    @CheckForNull
    public CNode describe(T instance, ConfigurationContext context) throws Exception {
        T ref = this.target.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return this.compare(instance, ref, context);
    }
}

