/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Server;
import io.grpc.ServerServiceDefinition;
import io.grpc.xds.XdsClientWrapperForServerSds;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;

@VisibleForTesting
public final class ServerWrapperForXds
extends Server {
    private final Server delegate;
    private final XdsClientWrapperForServerSds xdsClientWrapperForServerSds;

    ServerWrapperForXds(Server delegate, XdsClientWrapperForServerSds xdsClientWrapperForServerSds) {
        this.delegate = (Server)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
        this.xdsClientWrapperForServerSds = (XdsClientWrapperForServerSds)Preconditions.checkNotNull((Object)xdsClientWrapperForServerSds, (Object)"xdsClientWrapperForServerSds");
    }

    public Server start() throws IOException {
        this.delegate.start();
        if (!this.xdsClientWrapperForServerSds.hasXdsClient()) {
            this.xdsClientWrapperForServerSds.createXdsClientAndStart();
        }
        return this;
    }

    public Server shutdown() {
        this.xdsClientWrapperForServerSds.shutdown();
        this.delegate.shutdown();
        return this;
    }

    public Server shutdownNow() {
        this.xdsClientWrapperForServerSds.shutdown();
        this.delegate.shutdownNow();
        return this;
    }

    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    public void awaitTermination() throws InterruptedException {
        this.delegate.awaitTermination();
    }

    public int getPort() {
        return this.delegate.getPort();
    }

    public List<? extends SocketAddress> getListenSockets() {
        return this.delegate.getListenSockets();
    }

    public List<ServerServiceDefinition> getServices() {
        return this.delegate.getServices();
    }

    public List<ServerServiceDefinition> getImmutableServices() {
        return this.delegate.getImmutableServices();
    }

    public List<ServerServiceDefinition> getMutableServices() {
        return this.delegate.getMutableServices();
    }
}

