/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.base.Preconditions;
import com.google.protobuf.ProtocolStringList;
import io.grpc.Status;
import io.grpc.netty.shaded.io.netty.handler.ssl.ApplicationProtocolConfig;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.internal.sds.SdsClient;
import io.grpc.xds.internal.sds.SslContextProvider;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Node;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SdsSecretConfig;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.Secret;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.TlsCertificate;
import java.io.IOException;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

abstract class SdsSslContextProvider
extends SslContextProvider
implements SdsClient.SecretWatcher {
    private static final Logger logger = Logger.getLogger(SdsSslContextProvider.class.getName());
    @Nullable
    private final SdsClient certSdsClient;
    @Nullable
    private final SdsClient validationContextSdsClient;
    @Nullable
    private final SdsSecretConfig certSdsConfig;
    @Nullable
    private final SdsSecretConfig validationContextSdsConfig;
    @Nullable
    private final CertificateValidationContext staticCertificateValidationContext;
    private final List<CallbackPair> pendingCallbacks = new ArrayList<CallbackPair>();
    @Nullable
    protected TlsCertificate tlsCertificate;
    @Nullable
    private CertificateValidationContext certificateValidationContext;
    @Nullable
    private SslContext sslContext;

    SdsSslContextProvider(Node node, SdsSecretConfig certSdsConfig, SdsSecretConfig validationContextSdsConfig, CertificateValidationContext staticCertValidationContext, Executor watcherExecutor, Executor channelExecutor, EnvoyServerProtoData.BaseTlsContext tlsContext) {
        super(tlsContext);
        this.certSdsConfig = certSdsConfig;
        this.validationContextSdsConfig = validationContextSdsConfig;
        this.staticCertificateValidationContext = staticCertValidationContext;
        if (certSdsConfig != null && certSdsConfig.isInitialized()) {
            this.certSdsClient = SdsClient.Factory.createSdsClient(certSdsConfig, node, watcherExecutor, channelExecutor);
            this.certSdsClient.start();
            this.certSdsClient.watchSecret(this);
        } else {
            this.certSdsClient = null;
        }
        if (validationContextSdsConfig != null && validationContextSdsConfig.isInitialized()) {
            this.validationContextSdsClient = SdsClient.Factory.createSdsClient(validationContextSdsConfig, node, watcherExecutor, channelExecutor);
            this.validationContextSdsClient.start();
            this.validationContextSdsClient.watchSecret(this);
        } else {
            this.validationContextSdsClient = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCallback(SslContextProvider.Callback callback, Executor executor) {
        Preconditions.checkNotNull((Object)callback, (Object)"callback");
        Preconditions.checkNotNull((Object)executor, (Object)"executor");
        SslContext sslContextCopy = this.sslContext;
        if (sslContextCopy != null) {
            this.callPerformCallback(callback, executor, sslContextCopy);
        } else {
            List<CallbackPair> list = this.pendingCallbacks;
            synchronized (list) {
                this.pendingCallbacks.add(new CallbackPair(callback, executor));
            }
        }
    }

    private void callPerformCallback(SslContextProvider.Callback callback, Executor executor, final SslContext sslContextCopy) {
        this.performCallback(new SslContextProvider.SslContextGetter(){

            @Override
            public SslContext get() {
                return sslContextCopy;
            }
        }, callback, executor);
    }

    @Override
    public synchronized void onSecretChanged(Secret secretUpdate) {
        Preconditions.checkNotNull((Object)secretUpdate);
        if (secretUpdate.hasTlsCertificate()) {
            Preconditions.checkState((boolean)secretUpdate.getName().equals(this.certSdsConfig.getName()), (Object)"tlsCert names don't match");
            logger.log(Level.FINEST, "onSecretChanged certSdsConfig.name={0}", this.certSdsConfig.getName());
            this.tlsCertificate = secretUpdate.getTlsCertificate();
            if (this.certificateValidationContext != null || this.validationContextSdsConfig == null) {
                this.updateSslContext();
            }
        } else if (secretUpdate.hasValidationContext()) {
            Preconditions.checkState((boolean)secretUpdate.getName().equals(this.validationContextSdsConfig.getName()), (Object)"validationContext names don't match");
            logger.log(Level.FINEST, "onSecretChanged validationContextSdsConfig.name={0}", this.validationContextSdsConfig.getName());
            this.certificateValidationContext = secretUpdate.getValidationContext();
            if (this.tlsCertificate != null || this.certSdsConfig == null) {
                this.updateSslContext();
            }
        } else {
            throw new UnsupportedOperationException("Unexpected secret type:" + (Object)((Object)secretUpdate.getTypeCase()));
        }
    }

    abstract SslContextBuilder getSslContextBuilder(CertificateValidationContext var1) throws CertificateException, IOException, CertStoreException;

    private void updateSslContext() {
        try {
            SslContext sslContextCopy;
            CertificateValidationContext localCertValidationContext = this.mergeStaticAndDynamicCertContexts();
            SslContextBuilder sslContextBuilder = this.getSslContextBuilder(localCertValidationContext);
            CommonTlsContext commonTlsContext = this.getCommonTlsContext();
            if (commonTlsContext != null && commonTlsContext.getAlpnProtocolsCount() > 0) {
                ProtocolStringList alpnList = commonTlsContext.getAlpnProtocolsList();
                ApplicationProtocolConfig apn = new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, (Iterable)alpnList);
                sslContextBuilder.applicationProtocolConfig(apn);
            }
            this.sslContext = sslContextCopy = sslContextBuilder.build();
            this.makePendingCallbacks(sslContextCopy);
        }
        catch (IOException | CertStoreException | CertificateException e) {
            logger.log(Level.SEVERE, "exception in updateSslContext", e);
        }
    }

    private CertificateValidationContext mergeStaticAndDynamicCertContexts() {
        if (this.staticCertificateValidationContext == null) {
            return this.certificateValidationContext;
        }
        if (this.certificateValidationContext == null) {
            return this.staticCertificateValidationContext;
        }
        CertificateValidationContext.Builder localCertContextBuilder = this.certificateValidationContext.toBuilder();
        return localCertContextBuilder.mergeFrom(this.staticCertificateValidationContext).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makePendingCallbacks(SslContext sslContextCopy) {
        List<CallbackPair> list = this.pendingCallbacks;
        synchronized (list) {
            for (CallbackPair pair : this.pendingCallbacks) {
                this.callPerformCallback(pair.callback, pair.executor, sslContextCopy);
            }
            this.pendingCallbacks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Status error) {
        List<CallbackPair> list = this.pendingCallbacks;
        synchronized (list) {
            for (CallbackPair callbackPair : this.pendingCallbacks) {
                callbackPair.callback.onException((Throwable)error.asException());
            }
            this.pendingCallbacks.clear();
        }
    }

    @Override
    public void close() {
        if (this.certSdsClient != null) {
            this.certSdsClient.cancelSecretWatch(this);
            this.certSdsClient.shutdown();
        }
        if (this.validationContextSdsClient != null) {
            this.validationContextSdsClient.cancelSecretWatch(this);
            this.validationContextSdsClient.shutdown();
        }
    }

    private static class CallbackPair {
        private final SslContextProvider.Callback callback;
        private final Executor executor;

        private CallbackPair(SslContextProvider.Callback callback, Executor executor) {
            this.callback = callback;
            this.executor = executor;
        }
    }
}

