/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.protobuf.Duration;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import com.google.protobuf.util.Durations;
import io.grpc.Channel;
import io.grpc.InternalLogId;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.BackoffPolicy;
import io.grpc.stub.StreamObserver;
import io.grpc.xds.LoadStatsManager;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Node;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v2.LoadReportingServiceGrpc;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v2.LoadStatsRequest;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v2.LoadStatsResponse;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class LoadReportClient {
    @VisibleForTesting
    static final String TARGET_NAME_METADATA_KEY = "PROXYLESS_CLIENT_HOSTNAME";
    private final InternalLogId logId;
    private final XdsLogger logger;
    private final ManagedChannel channel;
    private final Node node;
    private final SynchronizationContext syncContext;
    private final ScheduledExecutorService timerService;
    private final Supplier<Stopwatch> stopwatchSupplier;
    private final Stopwatch retryStopwatch;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final LoadStatsManager loadStatsManager;
    private boolean started;
    @Nullable
    private BackoffPolicy lrsRpcRetryPolicy;
    @Nullable
    private SynchronizationContext.ScheduledHandle lrsRpcRetryTimer;
    @Nullable
    private LrsStream lrsStream;

    LoadReportClient(String targetName, LoadStatsManager loadStatsManager, ManagedChannel channel, Node node, SynchronizationContext syncContext, ScheduledExecutorService scheduledExecutorService, BackoffPolicy.Provider backoffPolicyProvider, Supplier<Stopwatch> stopwatchSupplier) {
        this.loadStatsManager = (LoadStatsManager)Preconditions.checkNotNull((Object)loadStatsManager, (Object)"loadStatsManager");
        this.channel = (ManagedChannel)Preconditions.checkNotNull((Object)channel, (Object)"channel");
        this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)syncContext, (Object)"syncContext");
        this.timerService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduledExecutorService, (Object)"timeService");
        this.backoffPolicyProvider = (BackoffPolicy.Provider)Preconditions.checkNotNull((Object)backoffPolicyProvider, (Object)"backoffPolicyProvider");
        this.stopwatchSupplier = (Supplier)Preconditions.checkNotNull(stopwatchSupplier, (Object)"stopwatchSupplier");
        this.retryStopwatch = (Stopwatch)stopwatchSupplier.get();
        Preconditions.checkNotNull((Object)targetName, (Object)"targetName");
        Preconditions.checkNotNull((Object)node, (Object)"node");
        Struct metadata = node.getMetadata().toBuilder().putFields(TARGET_NAME_METADATA_KEY, Value.newBuilder().setStringValue(targetName).build()).build();
        this.node = node.toBuilder().setMetadata(metadata).build();
        this.logId = InternalLogId.allocate((String)"lrs-client", (String)targetName);
        this.logger = XdsLogger.withLogId(this.logId);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    void startLoadReporting() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Starting load reporting RPC");
        this.startLrsRpc();
    }

    void stopLoadReporting() {
        if (!this.started) {
            return;
        }
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Stopping load reporting RPC");
        if (this.lrsRpcRetryTimer != null) {
            this.lrsRpcRetryTimer.cancel();
        }
        if (this.lrsStream != null) {
            this.lrsStream.close((Exception)Status.CANCELLED.withDescription("stop load reporting").asException());
        }
        this.started = false;
    }

    private void startLrsRpc() {
        Preconditions.checkState((this.lrsStream == null ? 1 : 0) != 0, (Object)"previous lbStream has not been cleared yet");
        LoadReportingServiceGrpc.LoadReportingServiceStub stub = LoadReportingServiceGrpc.newStub((Channel)this.channel);
        this.lrsStream = new LrsStream(stub, (Stopwatch)this.stopwatchSupplier.get());
        this.retryStopwatch.reset().start();
        this.lrsStream.start();
    }

    private class LrsStream
    implements StreamObserver<LoadStatsResponse> {
        final LoadReportingServiceGrpc.LoadReportingServiceStub stub;
        StreamObserver<LoadStatsRequest> lrsRequestWriter;
        boolean initialResponseReceived;
        boolean closed;
        long loadReportIntervalNano = -1L;
        boolean reportAllClusters;
        List<String> clusterNames;
        SynchronizationContext.ScheduledHandle loadReportTimer;

        LrsStream(LoadReportingServiceGrpc.LoadReportingServiceStub stub, Stopwatch stopwatch) {
            this.stub = (LoadReportingServiceGrpc.LoadReportingServiceStub)((Object)Preconditions.checkNotNull((Object)((Object)stub), (Object)"stub"));
        }

        void start() {
            this.lrsRequestWriter = ((LoadReportingServiceGrpc.LoadReportingServiceStub)this.stub.withWaitForReady()).streamLoadStats(this);
            LoadStatsRequest initRequest = LoadStatsRequest.newBuilder().setNode(LoadReportClient.this.node).build();
            this.lrsRequestWriter.onNext((Object)initRequest);
            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Initial LRS request sent:\n{0}", initRequest);
        }

        public void onNext(final LoadStatsResponse response) {
            LoadReportClient.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    LrsStream.this.handleResponse(response);
                }
            });
        }

        public void onError(final Throwable t) {
            LoadReportClient.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    LrsStream.this.handleStreamClosed(Status.fromThrowable((Throwable)t));
                }
            });
        }

        public void onCompleted() {
            LoadReportClient.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    LrsStream.this.handleStreamClosed(Status.UNAVAILABLE.withDescription("Closed by server"));
                }
            });
        }

        private void sendLoadReport() {
            LoadStatsRequest.Builder requestBuilder = LoadStatsRequest.newBuilder().setNode(LoadReportClient.this.node);
            if (this.reportAllClusters) {
                requestBuilder.addAllClusterStats(LoadReportClient.this.loadStatsManager.getAllLoadReports());
            } else {
                for (String name : this.clusterNames) {
                    requestBuilder.addAllClusterStats(LoadReportClient.this.loadStatsManager.getClusterLoadReports(name));
                }
            }
            LoadStatsRequest request = requestBuilder.build();
            this.lrsRequestWriter.onNext((Object)request);
            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Sent LoadStatsRequest\n{0}", request);
            this.scheduleNextLoadReport();
        }

        private void scheduleNextLoadReport() {
            if (this.loadReportTimer != null && this.loadReportTimer.isPending()) {
                this.loadReportTimer.cancel();
                this.loadReportTimer = null;
            }
            if (this.loadReportIntervalNano > 0L) {
                this.loadReportTimer = LoadReportClient.this.syncContext.schedule((Runnable)new LoadReportingTask(this), this.loadReportIntervalNano, TimeUnit.NANOSECONDS, LoadReportClient.this.timerService);
            }
        }

        private void handleResponse(LoadStatsResponse response) {
            if (this.closed) {
                return;
            }
            if (!this.initialResponseReceived) {
                LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received LRS initial response:\n{0}", response);
                this.initialResponseReceived = true;
            } else {
                LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received LRS response:\n{0}", response);
            }
            this.reportAllClusters = response.getSendAllClusters();
            if (this.reportAllClusters) {
                LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Report loads for all clusters");
            } else {
                LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Report loads for clusters: ", response.getClustersList());
                this.clusterNames = response.getClustersList();
            }
            long interval = Durations.toNanos((Duration)response.getLoadReportingInterval());
            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Update load reporting interval to {0} ns", interval);
            this.loadReportIntervalNano = interval;
            this.scheduleNextLoadReport();
        }

        private void handleStreamClosed(Status status) {
            Preconditions.checkArgument((!status.isOk() ? 1 : 0) != 0, (Object)"unexpected OK status");
            if (this.closed) {
                return;
            }
            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.ERROR, "LRS stream closed with status {0}: {1}. Cause: {2}", status.getCode(), status.getDescription(), status.getCause());
            this.closed = true;
            this.cleanUp();
            long delayNanos = 0L;
            if (this.initialResponseReceived || LoadReportClient.this.lrsRpcRetryPolicy == null) {
                LoadReportClient.this.lrsRpcRetryPolicy = LoadReportClient.this.backoffPolicyProvider.get();
            }
            if (!this.initialResponseReceived) {
                delayNanos = LoadReportClient.this.lrsRpcRetryPolicy.nextBackoffNanos() - LoadReportClient.this.retryStopwatch.elapsed(TimeUnit.NANOSECONDS);
            }
            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Retry LRS stream in {0} ns", delayNanos);
            if (delayNanos <= 0L) {
                LoadReportClient.this.startLrsRpc();
            } else {
                LoadReportClient.this.lrsRpcRetryTimer = LoadReportClient.this.syncContext.schedule((Runnable)new LrsRpcRetryTask(), delayNanos, TimeUnit.NANOSECONDS, LoadReportClient.this.timerService);
            }
        }

        private void close(@Nullable Exception error) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.cleanUp();
            if (error == null) {
                this.lrsRequestWriter.onCompleted();
            } else {
                this.lrsRequestWriter.onError((Throwable)error);
            }
        }

        private void cleanUp() {
            if (this.loadReportTimer != null) {
                this.loadReportTimer.cancel();
                this.loadReportTimer = null;
            }
            if (LoadReportClient.this.lrsStream == this) {
                LoadReportClient.this.lrsStream = null;
            }
        }
    }

    @VisibleForTesting
    class LrsRpcRetryTask
    implements Runnable {
        LrsRpcRetryTask() {
        }

        @Override
        public void run() {
            LoadReportClient.this.startLrsRpc();
        }
    }

    @VisibleForTesting
    static class LoadReportingTask
    implements Runnable {
        private final LrsStream stream;

        LoadReportingTask(LrsStream stream) {
            this.stream = stream;
        }

        @Override
        public void run() {
            this.stream.sendLoadReport();
        }
    }
}

