/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.protostar.util;

import io.github.yezhihao.protostar.util.Cache;
import java.beans.Transient;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;

public class ToStringBuilder {
    private static Cache<String, Builder[]> CACHE = new Cache(new WeakHashMap());

    public static String toString(Object object) {
        return ToStringBuilder.toString(null, object, true, (String[])null);
    }

    public static String toString(Object object, boolean superclass, String ... ignores) {
        return ToStringBuilder.toString(null, object, superclass, ignores);
    }

    public static String toString(StringBuilder sb, Object object, boolean superclass, String ... ignores) {
        Class<?> typeClass = object.getClass();
        Builder[] builders = ToStringBuilder.getBuilders(typeClass, ignores);
        if (sb == null) {
            sb = new StringBuilder(builders.length * 10);
        }
        String name = typeClass.getName();
        sb.append(name, name.lastIndexOf(46) + 1, name.length());
        sb.append('{');
        try {
            if (superclass) {
                for (Builder builder : builders) {
                    builder.append(sb, object);
                }
            } else {
                for (Builder builder : builders) {
                    if (builder.superclass) continue;
                    builder.append(sb, object);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    private static Builder[] getBuilders(Class<?> typeClass, String ... ignores) {
        return CACHE.get(typeClass.getName(), () -> {
            Method[] methods = typeClass.getMethods();
            ArrayList<Builder> result = new ArrayList<Builder>(methods.length);
            for (Method method : methods) {
                String mName = method.getName();
                String name = ToStringBuilder.getName(mName);
                if (!mName.startsWith("get") && !mName.startsWith("is") || "class".equals(name) || ToStringBuilder.contains(ignores, name) || method.getParameterCount() != 0 || method.isAnnotationPresent(Transient.class)) continue;
                result.add(new Builder(name, method, !typeClass.equals(method.getDeclaringClass())));
            }
            Object[] temp = new Builder[result.size()];
            result.toArray(temp);
            Arrays.sort(temp);
            return temp;
        });
    }

    private static boolean contains(Object[] array, Object obj) {
        if (array == null || array.length == 0 || obj == null) {
            return false;
        }
        for (Object t : array) {
            if (!obj.equals(t)) continue;
            return true;
        }
        return false;
    }

    private static String getName(String methodName) {
        char[] name = methodName.toCharArray();
        if (name[0] == 'g') {
            name[3] = (char)(name[3] + 32);
            return new String(name, 3, name.length - 3);
        }
        name[2] = (char)(name[2] + 32);
        return new String(name, 2, name.length - 2);
    }

    private static class Builder
    implements Comparable<Builder> {
        private static final BiConsumer<StringBuilder, Object> APPEND_OBJ = StringBuilder::append;
        private static final BiConsumer<StringBuilder, Object> APPEND_ARRAY = (sb, array) -> {
            sb.append('[');
            int length = Array.getLength(array);
            boolean tooLong = length > 140;
            length = tooLong ? 140 : length;
            for (int i = 0; i < length; ++i) {
                sb.append(Array.get(array, i)).append(',');
            }
            if (tooLong) {
                sb.append("......");
            }
            sb.setCharAt(sb.length() - 1, ']');
        };
        public final String name;
        public final boolean superclass;
        private final Method method;
        private final BiConsumer<StringBuilder, Object> append;

        public void append(StringBuilder sb, Object obj) throws Exception {
            Object value = this.method.invoke(obj, new Object[0]);
            if (value != null) {
                sb.append(this.name).append('=');
                this.append.accept(sb, value);
                sb.append(',');
            }
        }

        public Builder(String name, Method method, boolean superclass) {
            this.name = name;
            this.method = method;
            this.superclass = superclass;
            this.append = method.getReturnType().isArray() ? APPEND_ARRAY : APPEND_OBJ;
        }

        @Override
        public int compareTo(Builder that) {
            Class<?> thatType = that.method.getReturnType();
            if (Iterable.class.isAssignableFrom(thatType) || thatType.isArray()) {
                return -1;
            }
            Class<?> thisType = this.method.getReturnType();
            if (Iterable.class.isAssignableFrom(thisType) || thisType.isArray()) {
                return 1;
            }
            return 0;
        }
    }
}

