/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.protostar.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;

public class StrUtils {
    public static String toString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof ByteBuf) {
            return ByteBufUtil.hexDump((ByteBuf)((ByteBuf)value));
        }
        if (!value.getClass().isArray()) {
            return value.toString();
        }
        StringBuilder root = new StringBuilder(32);
        StrUtils.toString(value, root);
        return root.toString();
    }

    public static StringBuilder toString(Object value, StringBuilder builder) {
        int end;
        Object[] array;
        if (value == null) {
            return builder;
        }
        builder.append('[');
        int start = builder.length();
        if (value instanceof long[]) {
            for (long t : array = (long[])value) {
                builder.append(t).append(',');
            }
        } else if (value instanceof int[]) {
            for (long t : array = (Object[])((int[])value)) {
                builder.append((int)t).append(',');
            }
        } else if (value instanceof short[]) {
            for (long t : array = (Object[])((short[])value)) {
                builder.append((int)t).append(',');
            }
        } else if (value instanceof byte[]) {
            for (long t : array = (Object[])((byte[])value)) {
                builder.append((int)t).append(',');
            }
        } else if (value instanceof char[]) {
            for (long t : array = (Object[])((char[])value)) {
                builder.append((char)t).append(',');
            }
        } else if (value instanceof double[]) {
            for (long t : array = (Object[])((double[])value)) {
                builder.append((double)t).append(',');
            }
        } else if (value instanceof float[]) {
            for (long t : array = (Object[])((float[])value)) {
                builder.append((float)t).append(',');
            }
        } else if (value instanceof boolean[]) {
            for (long t : array = (Object[])((boolean[])value)) {
                builder.append((boolean)t).append(',');
            }
        } else if (value instanceof String[]) {
            for (long t : array = (Object[])((String[])value)) {
                builder.append((String)t).append(',');
            }
        } else if (StrUtils.isArray(value)) {
            for (long t : array = (Object[])((Object[])value)) {
                StrUtils.toString(t, builder).append(',');
            }
        } else if (value instanceof Object[]) {
            for (long t : array = (Object[])((Object[])value)) {
                builder.append((Object)t).append(',');
            }
        }
        if ((end = builder.length()) <= start) {
            builder.append(']');
        } else {
            builder.setCharAt(end - 1, ']');
        }
        return builder;
    }

    private static boolean isArray(Object value) {
        Class<?> componentType = value.getClass().getComponentType();
        if (componentType == null) {
            return false;
        }
        return componentType.isArray();
    }

    public static String leftPad(String str, int size, char ch) {
        int length = str.length();
        int pads = size - length;
        if (pads > 0) {
            char[] result = new char[size];
            str.getChars(0, length, result, pads);
            while (pads > 0) {
                result[--pads] = ch;
            }
            return new String(result);
        }
        return str;
    }
}

