/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.protostar.util;

import io.netty.buffer.ByteBuf;

public interface IntTool {
    public static final IntTool ALL = new IntTool(){

        @Override
        public int get(ByteBuf in, int i) {
            return -1;
        }

        @Override
        public void set(ByteBuf out, int i, int n) {
        }

        @Override
        public int read(ByteBuf in) {
            return -1;
        }

        @Override
        public void write(ByteBuf out, int n) {
        }
    };
    public static final IntTool BYTE = new IntTool(){

        @Override
        public int get(ByteBuf in, int i) {
            return in.getUnsignedByte(i);
        }

        @Override
        public void set(ByteBuf out, int i, int n) {
            out.setByte(i, n);
        }

        @Override
        public int read(ByteBuf in) {
            return in.readUnsignedByte();
        }

        @Override
        public void write(ByteBuf out, int n) {
            out.writeByte(n);
        }
    };
    public static final IntTool WORD = new IntTool(){

        @Override
        public int get(ByteBuf in, int i) {
            return in.getUnsignedShort(i);
        }

        @Override
        public void set(ByteBuf out, int i, int n) {
            out.setShort(i, n);
        }

        @Override
        public int read(ByteBuf in) {
            return in.readUnsignedShort();
        }

        @Override
        public void write(ByteBuf out, int n) {
            out.writeShort(n);
        }
    };
    public static final IntTool MEDIUM = new IntTool(){

        @Override
        public int get(ByteBuf in, int i) {
            return in.getUnsignedMedium(i);
        }

        @Override
        public void set(ByteBuf out, int i, int n) {
            out.setMedium(i, n);
        }

        @Override
        public int read(ByteBuf in) {
            return in.readUnsignedMedium();
        }

        @Override
        public void write(ByteBuf out, int n) {
            out.writeMedium(n);
        }
    };
    public static final IntTool DWORD = new IntTool(){

        @Override
        public int get(ByteBuf in, int i) {
            return in.getInt(i);
        }

        @Override
        public void set(ByteBuf out, int i, int n) {
            out.setInt(i, n);
        }

        @Override
        public int read(ByteBuf in) {
            return in.readInt();
        }

        @Override
        public void write(ByteBuf out, int n) {
            out.writeInt(n);
        }
    };

    public static IntTool getInstance(int length) {
        switch (length) {
            case -1: 
            case 0: {
                return ALL;
            }
            case 1: {
                return BYTE;
            }
            case 2: {
                return WORD;
            }
            case 3: {
                return MEDIUM;
            }
            case 4: {
                return DWORD;
            }
        }
        throw new IllegalArgumentException("unsupported length: " + length + " (expected: 1, 2, 3, 4)");
    }

    public int get(ByteBuf var1, int var2);

    public void set(ByteBuf var1, int var2, int var3);

    public int read(ByteBuf var1);

    public void write(ByteBuf var1, int var2);
}

