/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.protostar.util;

import io.github.yezhihao.protostar.util.StrUtils;

public class Info {
    protected int index;
    protected String desc;
    protected Object value;
    protected String raw;

    private Info(int index, String desc, Object value, String raw) {
        this.index = index;
        this.desc = desc;
        this.value = value;
        this.raw = raw;
    }

    public static Info field(int index, String desc, Object value, String raw) {
        return new Info(index, desc, value, raw);
    }

    public static Info lengthField(int index, String desc, int value, int lengthUnit) {
        return new Info(index, desc, value, StrUtils.leftPad(Integer.toHexString(value), 1 << lengthUnit, '0'));
    }

    public int getIndex() {
        return this.index;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getRaw() {
        return this.raw;
    }

    public Object getValue() {
        return this.value;
    }

    public void setLength(int length, int lengthUnit) {
        this.value = length;
        this.raw = StrUtils.leftPad(Integer.toHexString(length), 1 << lengthUnit, '0');
    }

    public String toString() {
        if (this.desc == null) {
            return this.index + "\t[" + this.raw + "] [" + StrUtils.toString(this.value) + "]";
        }
        return this.index + "\t[" + this.raw + "] [" + StrUtils.toString(this.value) + "] " + this.desc;
    }
}

