/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.protostar.util;

import io.netty.buffer.ByteBuf;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

public class DateTool {
    public static final DateTool BYTE = new DateTool();
    public static final DateTool BCD = new BCD();
    public static final int YEAR = LocalDate.now().getYear();
    public static final int YEAR_RANGE = YEAR - 30;
    public static final int HUNDRED_YEAR = YEAR_RANGE / 100 * 100;

    public static int getYear(int year) {
        if ((year += HUNDRED_YEAR) < YEAR_RANGE) {
            year += 100;
        }
        return year;
    }

    public final byte[] from(LocalDateTime dateTime) {
        byte[] bytes = new byte[]{this.toByte(dateTime.getYear() % 100), this.toByte(dateTime.getMonthValue()), this.toByte(dateTime.getDayOfMonth()), this.toByte(dateTime.getHour()), this.toByte(dateTime.getMinute()), this.toByte(dateTime.getSecond())};
        return bytes;
    }

    public final LocalDateTime toDateTime(byte[] bytes) {
        try {
            return LocalDateTime.of(DateTool.getYear(this.toInt(bytes[0])), this.toInt(bytes[1]), this.toInt(bytes[2]), this.toInt(bytes[3]), this.toInt(bytes[4]), this.toInt(bytes[5]));
        }
        catch (Exception e) {
            return null;
        }
    }

    public final byte[] from(LocalDate date) {
        return new byte[]{this.toByte(date.getYear() % 100), this.toByte(date.getMonthValue()), this.toByte(date.getDayOfMonth())};
    }

    public final LocalDate toDate(byte[] bytes) {
        return LocalDate.of(DateTool.getYear(this.toInt(bytes[0])), this.toInt(bytes[1]), this.toInt(bytes[2]));
    }

    public final byte[] from(LocalTime time) {
        return new byte[]{this.toByte(time.getHour()), this.toByte(time.getMinute()), this.toByte(time.getSecond())};
    }

    public final LocalTime toTime(byte[] bytes) {
        return LocalTime.of(this.toInt(bytes[0]), this.toInt(bytes[1]), this.toInt(bytes[2]));
    }

    public final void writeTime2(ByteBuf output, LocalTime time) {
        output.writeByte((int)this.toByte(time.getHour())).writeByte((int)this.toByte(time.getMinute()));
    }

    public final LocalTime readTime2(ByteBuf input) {
        return LocalTime.of(this.toInt(input.readByte()), this.toInt(input.readByte()));
    }

    private DateTool() {
    }

    public byte toByte(int i) {
        return (byte)i;
    }

    public int toInt(byte b) {
        return b & 0xFF;
    }

    private static class BCD
    extends DateTool {
        private BCD() {
        }

        @Override
        public byte toByte(int i) {
            return (byte)(i / 10 << 4 | i % 10 & 0xF);
        }

        @Override
        public int toInt(byte b) {
            return (b >> 4 & 0xF) * 10 + (b & 0xF);
        }
    }
}

