/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.protostar.util;

import java.util.Arrays;

public class CharsBuilder
implements CharSequence,
Appendable {
    private char[] value;
    private int pos;

    public CharsBuilder(int length) {
        this.value = new char[length];
    }

    public CharsBuilder(char[] chars) {
        this.value = chars;
    }

    @Override
    public Appendable append(CharSequence s) {
        return this.append(s, 0, s.length());
    }

    @Override
    public Appendable append(CharSequence s, int start, int end) {
        int len = end - start;
        int i = start;
        int j = this.pos;
        while (i < end) {
            this.value[j] = s.charAt(i);
            ++i;
            ++j;
        }
        this.pos += len;
        return this;
    }

    @Override
    public Appendable append(char c) {
        this.value[this.pos++] = c;
        return this;
    }

    @Override
    public char charAt(int index) {
        return this.value[index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start == end) {
            return new CharsBuilder(Math.min(16, this.value.length));
        }
        return new CharsBuilder(Arrays.copyOfRange(this.value, start, end));
    }

    @Override
    public int length() {
        return this.value.length;
    }

    @Override
    public String toString() {
        return new String(this.value);
    }

    public String leftStrip(char c) {
        int i = CharsBuilder.leftOf(this.value, c);
        return new String(this.value, i, this.value.length - i);
    }

    public String rightStrip(char c) {
        int i = CharsBuilder.rightOf(this.value, c);
        return new String(this.value, 0, i);
    }

    public static int leftOf(char[] chars, char pad) {
        int i;
        int len = chars.length;
        for (i = 0; i < len && chars[i] == pad; ++i) {
        }
        return i;
    }

    public static int rightOf(char[] chars, char pad) {
        int len;
        int i = 0;
        for (len = chars.length; i < len && chars[len - 1] <= pad; --len) {
        }
        return len;
    }
}

