/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.protostar.util;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class Cache<K, V> {
    private volatile Map<K, V> cache;

    public Cache() {
        this(32);
    }

    public Cache(Map<K, V> cache) {
        this.cache = cache;
    }

    public Cache(int initialCapacity) {
        this.cache = new HashMap((int)((double)initialCapacity / 0.75) + 1);
    }

    public V get(K key) {
        return this.cache.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key, Supplier<V> function) {
        V value = this.cache.get(key);
        if (value == null) {
            Map<K, V> map = this.cache;
            synchronized (map) {
                value = this.cache.get(key);
                if (value == null) {
                    value = function.get();
                    this.cache.put(key, value);
                }
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V value) {
        Map<K, V> map = this.cache;
        synchronized (map) {
            this.cache.put(key, value);
        }
        return value;
    }

    public String toString() {
        return this.cache.toString();
    }
}

