/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.protostar.util;

import java.util.ArrayList;
import java.util.List;

public class ArrayMap<T> {
    public static final int DEFAULT_KEY = Integer.MAX_VALUE;
    private T[] array = new Object[2];
    private boolean init = true;
    private int min;
    private int max;

    public T get(int key) {
        if (key < this.min || key > this.max) {
            return null;
        }
        return this.array[key - this.min];
    }

    public T getOrDefault(int key) {
        if (key < this.min || key > this.max) {
            return this.array[this.array.length - 1];
        }
        return this.array[key - this.min];
    }

    public void defaultValue(T value) {
        this.array[this.array.length - 1] = value;
    }

    public void put(int key, T value) {
        if (key == Integer.MAX_VALUE) {
            this.defaultValue(value);
            return;
        }
        if (this.init) {
            this.init = false;
            this.min = key;
            this.max = key;
        }
        int offset = Math.max(0, this.min - key);
        if (key < this.min) {
            this.min = key;
        }
        if (key > this.max) {
            this.max = key;
        }
        this.ensureCapacityInternal(offset);
        this.array[key - this.min] = value;
    }

    private void ensureCapacityInternal(int offset) {
        int minCapacity = this.max - this.min + 2;
        if (minCapacity > 256) {
            throw new IllegalArgumentException("min:" + this.min + ", max:" + this.max + "key\u7684\u533a\u95f4\u8fc7\u5927");
        }
        int length = this.array.length - 1;
        if (minCapacity >= length) {
            Object[] temp = new Object[minCapacity];
            System.arraycopy(this.array, 0, temp, offset, length);
            temp[temp.length - 1] = this.array[length];
            this.array = temp;
        } else if (offset > 0) {
            System.arraycopy(this.array, 0, this.array, offset, length);
        }
    }

    public List<T> values() {
        ArrayList<T> values = new ArrayList<T>(this.array.length);
        for (T t : this.array) {
            if (t == null) continue;
            values.add(t);
        }
        return values;
    }

    public int[] keys() {
        int length = this.size();
        int[] keys = new int[length];
        int count = 0;
        for (int i = 0; i < this.array.length; ++i) {
            if (this.array[i] == null) continue;
            keys[count++] = i + this.min;
        }
        if (this.array[this.array.length - 1] != null) {
            keys[keys.length - 1] = Integer.MAX_VALUE;
        }
        return keys;
    }

    public int size() {
        int count = 0;
        for (int i = 0; i < this.array.length; ++i) {
            if (this.array[i] == null) continue;
            ++count;
        }
        return count;
    }

    public ArrayMap<T> fillDefaultValue() {
        if (this.array.length == 2) {
            if (this.array[0] == null) {
                this.array[0] = this.array[1];
            }
        } else {
            for (int i = 0; i < this.array.length - 2; ++i) {
                if (this.array[i] != null) continue;
                this.array[i] = this.array[this.array.length - 1];
            }
        }
        return this;
    }
}

