/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.protostar.schema;

import io.github.yezhihao.protostar.Schema;
import io.github.yezhihao.protostar.field.BasicField;
import io.github.yezhihao.protostar.field.CollectionField;
import io.github.yezhihao.protostar.field.LengthField;
import io.github.yezhihao.protostar.field.LengthUnitCollectionField;
import io.github.yezhihao.protostar.field.LengthUnitField;
import io.github.yezhihao.protostar.field.MapField;
import io.github.yezhihao.protostar.field.TotalArrayObjectField;
import io.github.yezhihao.protostar.field.TotalArrayPrimitiveField;
import io.github.yezhihao.protostar.field.TotalCollectionField;
import io.github.yezhihao.protostar.field.TotalMapField;
import io.github.yezhihao.protostar.schema.ArraySchema;
import io.github.yezhihao.protostar.schema.BufferSchema;
import io.github.yezhihao.protostar.schema.DateTimeSchema;
import io.github.yezhihao.protostar.schema.MapSchema;
import io.github.yezhihao.protostar.schema.NumberPSchema;
import io.github.yezhihao.protostar.schema.NumberSchema;
import io.github.yezhihao.protostar.schema.StringSchema;
import io.github.yezhihao.protostar.util.DateTool;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public class SchemaRegistry {
    private static final Map<String, Function<DateTool, BasicField>> TIME_SCHEMA = new HashMap<String, Function<DateTool, BasicField>>(6);
    private static final Map<String, Supplier<BasicField>> NO_ARGS = new HashMap<String, Supplier<BasicField>>(128);
    private static final Map<String, Integer> NUMBER = new HashMap<String, Integer>(12);

    public static void register(Class typeClass, Supplier<BasicField> supplier, int length, String charset) {
        NO_ARGS.put(typeClass.getName() + "/" + length + "/" + charset, supplier);
    }

    public static void register(Class typeClass, Supplier<BasicField> supplier, int length) {
        NO_ARGS.put(typeClass.getName() + "/" + length, supplier);
    }

    public static void register(Class typeClass, Supplier<BasicField> supplier, String charset) {
        NO_ARGS.put(typeClass.getName() + "/" + charset, supplier);
    }

    public static void register(Class typeClass, Supplier schema) {
        NO_ARGS.put(typeClass.getName(), schema);
    }

    public static Schema getCustom(Class<? extends Schema> clazz) {
        try {
            return clazz.getDeclaredConstructor(null).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static BasicField get(io.github.yezhihao.protostar.annotation.Field field, Field f) {
        Class<?> typeClass = f.getType();
        String name = typeClass.getName();
        String charset = field.charset().toUpperCase();
        int length = field.length();
        if (NUMBER.containsKey(name)) {
            if (length > 0) {
                name = name + "/" + length;
            }
            if (charset.equals("LE")) {
                name = name + "/LE";
            }
            return NO_ARGS.get(name).get();
        }
        if (String.class.isAssignableFrom(typeClass)) {
            return StringSchema.getInstance(charset, length, field.lengthUnit());
        }
        if (Temporal.class.isAssignableFrom(typeClass)) {
            return TIME_SCHEMA.get(name).apply(charset.equals("BCD") ? DateTool.BCD : DateTool.BYTE);
        }
        if (Schema.class != field.converter()) {
            return SchemaRegistry.get(field, f, SchemaRegistry.getCustom(field.converter()));
        }
        Supplier<BasicField> supplier = NO_ARGS.get(name);
        if (supplier != null) {
            return SchemaRegistry.get(field, f, supplier.get());
        }
        return null;
    }

    public static BasicField get(io.github.yezhihao.protostar.annotation.Field field, Field f, Schema schema) {
        Class<?> typeClass = f.getType();
        if (field.totalUnit() > 0) {
            if (Collection.class.isAssignableFrom(typeClass)) {
                return new TotalCollectionField(schema, field.totalUnit());
            }
            if (Map.class.isAssignableFrom(typeClass)) {
                return new TotalMapField((MapSchema)schema, field.totalUnit(), typeClass);
            }
            if (typeClass.isArray()) {
                if ((typeClass = typeClass.getComponentType()).isPrimitive()) {
                    return new TotalArrayPrimitiveField(schema, field.totalUnit(), typeClass);
                }
                return new TotalArrayObjectField(schema, field.totalUnit(), typeClass);
            }
        }
        if (field.lengthUnit() > 0) {
            if (Collection.class.isAssignableFrom(typeClass)) {
                return new LengthUnitCollectionField(schema, field.lengthUnit());
            }
            return new LengthUnitField(schema, field.lengthUnit());
        }
        if (field.length() > 0) {
            return new LengthField(schema, field.length());
        }
        if (Collection.class.isAssignableFrom(typeClass)) {
            return new CollectionField(schema);
        }
        if (Map.class.isAssignableFrom(typeClass)) {
            return new MapField((MapSchema)schema, typeClass);
        }
        return (BasicField)schema;
    }

    public static int getLength(Class typeClass) {
        Integer len = NUMBER.get(typeClass.getName());
        if (len == null) {
            return -1;
        }
        return len;
    }

    static {
        NUMBER.put(Boolean.TYPE.getName(), 1);
        NUMBER.put(Character.TYPE.getName(), 2);
        NUMBER.put(Byte.TYPE.getName(), 1);
        NUMBER.put(Short.TYPE.getName(), 2);
        NUMBER.put(Integer.TYPE.getName(), 4);
        NUMBER.put(Long.TYPE.getName(), 8);
        NUMBER.put(Float.TYPE.getName(), 4);
        NUMBER.put(Double.TYPE.getName(), 8);
        NUMBER.put(Boolean.class.getName(), 1);
        NUMBER.put(Character.class.getName(), 2);
        NUMBER.put(Byte.class.getName(), 1);
        NUMBER.put(Short.class.getName(), 2);
        NUMBER.put(Integer.class.getName(), 4);
        NUMBER.put(Long.class.getName(), 8);
        NUMBER.put(Float.class.getName(), 4);
        NUMBER.put(Double.class.getName(), 8);
        SchemaRegistry.register(Short.TYPE, NumberPSchema.WORD2ShortLE::new, 2, "LE");
        SchemaRegistry.register(Integer.TYPE, NumberPSchema.WORD2IntLE::new, 2, "LE");
        SchemaRegistry.register(Integer.TYPE, NumberPSchema.DWORD2IntLE::new, 4, "LE");
        SchemaRegistry.register(Long.TYPE, NumberPSchema.DWORD2LongLE::new, 4, "LE");
        SchemaRegistry.register(Long.TYPE, NumberPSchema.QWORD2LongLE::new, 8, "LE");
        SchemaRegistry.register(Short.TYPE, NumberPSchema.WORD2ShortLE::new, "LE");
        SchemaRegistry.register(Integer.TYPE, NumberPSchema.DWORD2IntLE::new, "LE");
        SchemaRegistry.register(Long.TYPE, NumberPSchema.QWORD2LongLE::new, "LE");
        SchemaRegistry.register(Float.TYPE, NumberPSchema.DWORD2FloatLE::new, "LE");
        SchemaRegistry.register(Double.TYPE, NumberPSchema.QWORD2DoubleLE::new, "LE");
        SchemaRegistry.register(Byte.TYPE, NumberPSchema.BYTE2Byte::new, 1);
        SchemaRegistry.register(Short.TYPE, NumberPSchema.BYTE2Short::new, 1);
        SchemaRegistry.register(Integer.TYPE, NumberPSchema.BYTE2Int::new, 1);
        SchemaRegistry.register(Short.TYPE, NumberPSchema.WORD2Short::new, 2);
        SchemaRegistry.register(Integer.TYPE, NumberPSchema.WORD2Int::new, 2);
        SchemaRegistry.register(Integer.TYPE, NumberPSchema.DWORD2Int::new, 4);
        SchemaRegistry.register(Long.TYPE, NumberPSchema.DWORD2Long::new, 4);
        SchemaRegistry.register(Long.TYPE, NumberPSchema.QWORD2Long::new, 8);
        SchemaRegistry.register(Boolean.TYPE, NumberPSchema.BOOL::new);
        SchemaRegistry.register(Character.TYPE, NumberPSchema.CHAR::new);
        SchemaRegistry.register(Byte.TYPE, NumberPSchema.BYTE2Byte::new);
        SchemaRegistry.register(Short.TYPE, NumberPSchema.WORD2Short::new);
        SchemaRegistry.register(Integer.TYPE, NumberPSchema.DWORD2Int::new);
        SchemaRegistry.register(Long.TYPE, NumberPSchema.QWORD2Long::new);
        SchemaRegistry.register(Float.TYPE, NumberPSchema.DWORD2Float::new);
        SchemaRegistry.register(Double.TYPE, NumberPSchema.QWORD2Double::new);
        SchemaRegistry.register(Short.class, NumberSchema.WORD2ShortLE::new, 2, "LE");
        SchemaRegistry.register(Integer.class, NumberSchema.WORD2IntLE::new, 2, "LE");
        SchemaRegistry.register(Integer.class, NumberSchema.DWORD2IntLE::new, 4, "LE");
        SchemaRegistry.register(Long.class, NumberSchema.DWORD2LongLE::new, 4, "LE");
        SchemaRegistry.register(Long.class, NumberSchema.QWORD2LongLE::new, 8, "LE");
        SchemaRegistry.register(Short.class, NumberSchema.WORD2ShortLE::new, "LE");
        SchemaRegistry.register(Integer.class, NumberSchema.DWORD2IntLE::new, "LE");
        SchemaRegistry.register(Long.class, NumberSchema.QWORD2LongLE::new, "LE");
        SchemaRegistry.register(Float.class, NumberSchema.DWORD2FloatLE::new, "LE");
        SchemaRegistry.register(Double.class, NumberSchema.QWORD2DoubleLE::new, "LE");
        SchemaRegistry.register(Byte.class, NumberSchema.BYTE2Byte::new, 1);
        SchemaRegistry.register(Short.class, NumberSchema.BYTE2Short::new, 1);
        SchemaRegistry.register(Integer.class, NumberSchema.BYTE2Int::new, 1);
        SchemaRegistry.register(Short.class, NumberSchema.WORD2Short::new, 2);
        SchemaRegistry.register(Integer.class, NumberSchema.WORD2Int::new, 2);
        SchemaRegistry.register(Integer.class, NumberSchema.DWORD2Int::new, 4);
        SchemaRegistry.register(Long.class, NumberSchema.DWORD2Long::new, 4);
        SchemaRegistry.register(Long.class, NumberSchema.QWORD2Long::new, 8);
        SchemaRegistry.register(Boolean.class, NumberSchema.BOOL::new);
        SchemaRegistry.register(Character.class, NumberSchema.CHAR::new);
        SchemaRegistry.register(Byte.class, NumberSchema.BYTE2Byte::new);
        SchemaRegistry.register(Short.class, NumberSchema.WORD2Short::new);
        SchemaRegistry.register(Integer.class, NumberSchema.DWORD2Int::new);
        SchemaRegistry.register(Long.class, NumberSchema.QWORD2Long::new);
        SchemaRegistry.register(Float.class, NumberSchema.DWORD2Float::new);
        SchemaRegistry.register(Double.class, NumberSchema.QWORD2Double::new);
        SchemaRegistry.register(byte[].class, ArraySchema.ByteArray::new);
        SchemaRegistry.register(char[].class, ArraySchema.CharArray::new);
        SchemaRegistry.register(short[].class, ArraySchema.ShortArray::new);
        SchemaRegistry.register(int[].class, ArraySchema.IntArray::new);
        SchemaRegistry.register(long[].class, ArraySchema.LongArray::new);
        SchemaRegistry.register(float[].class, ArraySchema.FloatArray::new);
        SchemaRegistry.register(double[].class, ArraySchema.DoubleArray::new);
        SchemaRegistry.register(ByteBuffer.class, BufferSchema.ByteBufferSchema::new);
        SchemaRegistry.register(ByteBuf.class, BufferSchema.ByteBufSchema::new);
        TIME_SCHEMA.put(LocalTime.class.getName(), DateTimeSchema.Time::new);
        TIME_SCHEMA.put(LocalDate.class.getName(), DateTimeSchema.Date::new);
        TIME_SCHEMA.put(LocalDateTime.class.getName(), DateTimeSchema.DateTime::new);
    }
}

