/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.protostar.schema;

import io.github.yezhihao.protostar.Schema;
import io.github.yezhihao.protostar.field.BasicField;
import io.github.yezhihao.protostar.util.Explain;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;

public class RuntimeSchema<T>
implements Schema<T> {
    protected int version;
    protected int length;
    protected Class<T> typeClass;
    protected BasicField[] fields;
    protected Constructor<T> constructor;

    public RuntimeSchema(Class<T> typeClass, int version, BasicField[] fields) {
        this.typeClass = typeClass;
        this.version = version;
        this.fields = fields;
        int length = 0;
        for (BasicField field : fields) {
            length += field.length();
        }
        this.length = length;
        try {
            this.constructor = typeClass.getDeclaredConstructor(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public T newInstance() {
        try {
            return this.constructor.newInstance(null);
        }
        catch (Exception e) {
            throw new RuntimeException("newInstance failed " + this.typeClass.getName(), e);
        }
    }

    public T mergeFrom(ByteBuf input, T result) {
        int i;
        try {
            for (i = 0; i < this.fields.length; ++i) {
                this.fields[i].readAndSet(input, result);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Read failed " + i + " " + this.typeClass.getName() + " " + this.fields[i].fieldName(), e);
        }
    }

    public T mergeFrom(ByteBuf input, T result, Explain explain) {
        int i;
        try {
            if (explain == null) {
                for (i = 0; i < this.fields.length; ++i) {
                    this.fields[i].readAndSet(input, result);
                }
            } else {
                while (i < this.fields.length) {
                    this.fields[i].readAndSet(input, result, explain);
                    ++i;
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Read failed " + i + " " + this.typeClass.getName() + " " + this.fields[i].fieldName(), e);
        }
    }

    @Override
    public T readFrom(ByteBuf input) {
        int i;
        try {
            T result = this.constructor.newInstance(null);
            for (i = 0; i < this.fields.length; ++i) {
                this.fields[i].readAndSet(input, result);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Read failed " + i + " " + this.typeClass.getName() + " " + this.fields[i].fieldName(), e);
        }
    }

    @Override
    public T readFrom(ByteBuf input, Explain explain) {
        int i;
        try {
            T result = this.constructor.newInstance(null);
            if (explain == null) {
                for (i = 0; i < this.fields.length; ++i) {
                    this.fields[i].readAndSet(input, result);
                }
            } else {
                while (i < this.fields.length) {
                    this.fields[i].readAndSet(input, result, explain);
                    ++i;
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Read failed " + i + " " + this.typeClass.getName() + " " + this.fields[i].fieldName(), e);
        }
    }

    @Override
    public void writeTo(ByteBuf output, T message) {
        int i;
        try {
            for (i = 0; i < this.fields.length; ++i) {
                this.fields[i].getAndWrite(output, message);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Write failed " + i + " " + this.typeClass.getName() + " " + this.fields[i].fieldName(), e);
        }
    }

    @Override
    public void writeTo(ByteBuf output, T message, Explain explain) {
        int i;
        try {
            if (explain == null) {
                for (i = 0; i < this.fields.length; ++i) {
                    this.fields[i].getAndWrite(output, message);
                }
            } else {
                while (i < this.fields.length) {
                    this.fields[i].getAndWrite(output, message, explain);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Write failed " + i + " " + this.typeClass.getName() + " " + this.fields[i].fieldName(), e);
        }
    }

    public Class<T> typeClass() {
        return this.typeClass;
    }

    public int version() {
        return this.version;
    }

    @Override
    public int length() {
        return this.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(48);
        sb.append("{typeClass=").append(this.typeClass.getSimpleName());
        sb.append(", version=").append(this.version);
        sb.append(", length=").append(this.length);
        sb.append('}');
        return sb.toString();
    }
}

