/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.protostar.schema;

import io.github.yezhihao.protostar.Schema;
import io.github.yezhihao.protostar.field.BasicField;
import io.netty.buffer.ByteBuf;

public final class NumberSchema {
    public static final Schema<Boolean> BOOL = new BOOL();
    public static final Schema<Character> CHAR = new CHAR();
    public static final Schema<Byte> BYTE_BYTE = new BYTE2Byte();
    public static final Schema<Short> BYTE_SHORT = new BYTE2Short();
    public static final Schema<Integer> BYTE_INT = new BYTE2Int();
    public static final Schema<Short> WORD_SHORT = new WORD2Short();
    public static final Schema<Integer> WORD_INT = new WORD2Int();
    public static final Schema<Integer> DWORD_INT = new DWORD2Int();
    public static final Schema<Long> DWORD_LONG = new DWORD2Long();
    public static final Schema<Float> DWORD_FLOAT = new DWORD2Float();
    public static final Schema<Long> QWORD_LONG = new QWORD2Long();
    public static final Schema<Double> QWORD_DOUBLE = new QWORD2Double();
    public static final Schema<Short> WORD_SHORT_LE = new WORD2ShortLE();
    public static final Schema<Integer> WORD_INT_LE = new WORD2IntLE();
    public static final Schema<Integer> DWORD_INT_LE = new DWORD2IntLE();
    public static final Schema<Long> DWORD_LONG_LE = new DWORD2LongLE();
    public static final Schema<Float> DWORD_FLOAT_LE = new DWORD2FloatLE();
    public static final Schema<Long> QWORD_LONG_LE = new QWORD2LongLE();
    public static final Schema<Double> QWORD_DOUBLE_LE = new QWORD2DoubleLE();

    protected static class QWORD2DoubleLE
    extends BasicField<Double> {
        protected QWORD2DoubleLE() {
        }

        @Override
        public Double readFrom(ByteBuf input) {
            if (!input.isReadable()) {
                return null;
            }
            return input.readDoubleLE();
        }

        @Override
        public void writeTo(ByteBuf output, Double value) {
            if (value != null) {
                output.writeDoubleLE(value.doubleValue());
            }
        }
    }

    protected static class QWORD2LongLE
    extends BasicField<Long> {
        protected QWORD2LongLE() {
        }

        @Override
        public Long readFrom(ByteBuf input) {
            if (!input.isReadable()) {
                return null;
            }
            return input.readLongLE();
        }

        @Override
        public void writeTo(ByteBuf output, Long value) {
            if (value != null) {
                output.writeLongLE(value.longValue());
            }
        }
    }

    protected static class DWORD2FloatLE
    extends BasicField<Float> {
        protected DWORD2FloatLE() {
        }

        @Override
        public Float readFrom(ByteBuf input) {
            if (!input.isReadable()) {
                return null;
            }
            return Float.valueOf(input.readFloatLE());
        }

        @Override
        public void writeTo(ByteBuf output, Float value) {
            if (value != null) {
                output.writeFloatLE(value.floatValue());
            }
        }
    }

    protected static class DWORD2LongLE
    extends BasicField<Long> {
        protected DWORD2LongLE() {
        }

        @Override
        public Long readFrom(ByteBuf input) {
            if (!input.isReadable()) {
                return null;
            }
            return input.readUnsignedIntLE();
        }

        @Override
        public void writeTo(ByteBuf output, Long value) {
            if (value != null) {
                output.writeIntLE(value.intValue());
            }
        }
    }

    protected static class DWORD2IntLE
    extends BasicField<Integer> {
        protected DWORD2IntLE() {
        }

        @Override
        public Integer readFrom(ByteBuf input) {
            if (!input.isReadable()) {
                return null;
            }
            return input.readIntLE();
        }

        @Override
        public void writeTo(ByteBuf output, Integer value) {
            if (value != null) {
                output.writeIntLE(value.intValue());
            }
        }
    }

    protected static class WORD2IntLE
    extends BasicField<Integer> {
        protected WORD2IntLE() {
        }

        @Override
        public Integer readFrom(ByteBuf input) {
            if (!input.isReadable()) {
                return null;
            }
            return input.readUnsignedShortLE();
        }

        @Override
        public void writeTo(ByteBuf output, Integer value) {
            if (value != null) {
                output.writeShortLE(value.intValue());
            }
        }
    }

    protected static class WORD2ShortLE
    extends BasicField<Short> {
        protected WORD2ShortLE() {
        }

        @Override
        public Short readFrom(ByteBuf input) {
            if (!input.isReadable()) {
                return null;
            }
            return input.readShortLE();
        }

        @Override
        public void writeTo(ByteBuf output, Short value) {
            if (value != null) {
                output.writeShortLE((int)value.shortValue());
            }
        }
    }

    protected static class QWORD2Double
    extends BasicField<Double> {
        protected QWORD2Double() {
        }

        @Override
        public Double readFrom(ByteBuf input) {
            if (!input.isReadable()) {
                return null;
            }
            return input.readDouble();
        }

        @Override
        public void writeTo(ByteBuf output, Double value) {
            if (value != null) {
                output.writeDouble(value.doubleValue());
            }
        }
    }

    protected static class QWORD2Long
    extends BasicField<Long> {
        protected QWORD2Long() {
        }

        @Override
        public Long readFrom(ByteBuf input) {
            if (!input.isReadable()) {
                return null;
            }
            return input.readLong();
        }

        @Override
        public void writeTo(ByteBuf output, Long value) {
            if (value != null) {
                output.writeLong(value.longValue());
            }
        }
    }

    protected static class DWORD2Float
    extends BasicField<Float> {
        protected DWORD2Float() {
        }

        @Override
        public Float readFrom(ByteBuf input) {
            if (!input.isReadable()) {
                return null;
            }
            return Float.valueOf(input.readFloat());
        }

        @Override
        public void writeTo(ByteBuf output, Float value) {
            if (value != null) {
                output.writeFloat(value.floatValue());
            }
        }
    }

    protected static class DWORD2Long
    extends BasicField<Long> {
        protected DWORD2Long() {
        }

        @Override
        public Long readFrom(ByteBuf input) {
            if (!input.isReadable()) {
                return null;
            }
            return input.readUnsignedInt();
        }

        @Override
        public void writeTo(ByteBuf output, Long value) {
            if (value != null) {
                output.writeInt(value.intValue());
            }
        }
    }

    protected static class DWORD2Int
    extends BasicField<Integer> {
        protected DWORD2Int() {
        }

        @Override
        public Integer readFrom(ByteBuf input) {
            if (!input.isReadable()) {
                return null;
            }
            return input.readInt();
        }

        @Override
        public void writeTo(ByteBuf output, Integer value) {
            if (value != null) {
                output.writeInt(value.intValue());
            }
        }
    }

    protected static class WORD2Int
    extends BasicField<Integer> {
        protected WORD2Int() {
        }

        @Override
        public void readAndSet(ByteBuf input, Object obj) throws Exception {
            super.readAndSet(input, obj);
        }

        @Override
        public void getAndWrite(ByteBuf output, Object obj) throws Exception {
            super.getAndWrite(output, obj);
        }

        @Override
        public Integer readFrom(ByteBuf input) {
            if (!input.isReadable()) {
                return null;
            }
            return input.readUnsignedShort();
        }

        @Override
        public void writeTo(ByteBuf output, Integer value) {
            if (value != null) {
                output.writeShort(value.intValue());
            }
        }
    }

    protected static class WORD2Short
    extends BasicField<Short> {
        protected WORD2Short() {
        }

        @Override
        public Short readFrom(ByteBuf input) {
            if (!input.isReadable()) {
                return null;
            }
            return input.readShort();
        }

        @Override
        public void writeTo(ByteBuf output, Short value) {
            if (value != null) {
                output.writeShort((int)value.shortValue());
            }
        }
    }

    protected static class BYTE2Int
    extends BasicField<Integer> {
        protected BYTE2Int() {
        }

        @Override
        public Integer readFrom(ByteBuf input) {
            if (!input.isReadable()) {
                return null;
            }
            return input.readUnsignedByte();
        }

        @Override
        public void writeTo(ByteBuf output, Integer value) {
            if (value != null) {
                output.writeByte(value.intValue());
            }
        }
    }

    protected static class BYTE2Short
    extends BasicField<Short> {
        protected BYTE2Short() {
        }

        @Override
        public Short readFrom(ByteBuf input) {
            if (!input.isReadable()) {
                return null;
            }
            return input.readUnsignedByte();
        }

        @Override
        public void writeTo(ByteBuf output, Short value) {
            if (value != null) {
                output.writeByte((int)value.shortValue());
            }
        }
    }

    protected static class BYTE2Byte
    extends BasicField<Byte> {
        protected BYTE2Byte() {
        }

        @Override
        public Byte readFrom(ByteBuf input) {
            if (!input.isReadable()) {
                return null;
            }
            return input.readByte();
        }

        @Override
        public void writeTo(ByteBuf output, Byte value) {
            if (value != null) {
                output.writeByte((int)value.byteValue());
            }
        }
    }

    protected static class CHAR
    extends BasicField<Character> {
        protected CHAR() {
        }

        @Override
        public Character readFrom(ByteBuf input) {
            if (!input.isReadable()) {
                return null;
            }
            return Character.valueOf(input.readChar());
        }

        @Override
        public void writeTo(ByteBuf output, Character value) {
            if (value != null) {
                output.writeChar((int)value.charValue());
            }
        }
    }

    protected static class BOOL
    extends BasicField<Boolean> {
        protected BOOL() {
        }

        @Override
        public Boolean readFrom(ByteBuf input) {
            if (!input.isReadable()) {
                return null;
            }
            return input.readBoolean();
        }

        @Override
        public void writeTo(ByteBuf output, Boolean value) {
            if (value != null) {
                output.writeBoolean(value.booleanValue());
            }
        }
    }
}

