/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.protostar.schema;

import io.github.yezhihao.protostar.Schema;
import io.github.yezhihao.protostar.field.BasicField;
import io.netty.buffer.ByteBuf;

public final class NumberPSchema {
    public static final Schema<Boolean> BOOL = new BOOL();
    public static final Schema<Character> CHAR = new CHAR();
    public static final Schema<Byte> BYTE_BYTE = new BYTE2Byte();
    public static final Schema<Short> BYTE_SHORT = new BYTE2Short();
    public static final Schema<Integer> BYTE_INT = new BYTE2Int();
    public static final Schema<Short> WORD_SHORT = new WORD2Short();
    public static final Schema<Integer> WORD_INT = new WORD2Int();
    public static final Schema<Integer> DWORD_INT = new DWORD2Int();
    public static final Schema<Long> DWORD_LONG = new DWORD2Long();
    public static final Schema<Float> DWORD_FLOAT = new DWORD2Float();
    public static final Schema<Long> QWORD_LONG = new QWORD2Long();
    public static final Schema<Double> QWORD_DOUBLE = new QWORD2Double();
    public static final Schema<Short> WORD_SHORT_LE = new WORD2ShortLE();
    public static final Schema<Integer> WORD_INT_LE = new WORD2IntLE();
    public static final Schema<Integer> DWORD_INT_LE = new DWORD2IntLE();
    public static final Schema<Long> DWORD_LONG_LE = new DWORD2LongLE();
    public static final Schema<Float> DWORD_FLOAT_LE = new DWORD2FloatLE();
    public static final Schema<Long> QWORD_LONG_LE = new QWORD2LongLE();
    public static final Schema<Double> QWORD_DOUBLE_LE = new QWORD2DoubleLE();

    protected static class QWORD2DoubleLE
    extends BasicField<Double> {
        protected QWORD2DoubleLE() {
        }

        @Override
        public void readAndSet(ByteBuf input, Object obj) throws Exception {
            this.f.setDouble(obj, input.readDoubleLE());
        }

        @Override
        public void getAndWrite(ByteBuf output, Object obj) throws Exception {
            output.writeDoubleLE(this.f.getDouble(obj));
        }

        @Override
        public Double readFrom(ByteBuf input) {
            return input.readDoubleLE();
        }

        @Override
        public void writeTo(ByteBuf output, Double value) {
            output.writeDoubleLE(value.doubleValue());
        }
    }

    protected static class QWORD2LongLE
    extends BasicField<Long> {
        protected QWORD2LongLE() {
        }

        @Override
        public void readAndSet(ByteBuf input, Object obj) throws Exception {
            this.f.setLong(obj, input.readLongLE());
        }

        @Override
        public void getAndWrite(ByteBuf output, Object obj) throws Exception {
            output.writeLongLE(this.f.getLong(obj));
        }

        @Override
        public Long readFrom(ByteBuf input) {
            return input.readLongLE();
        }

        @Override
        public void writeTo(ByteBuf output, Long value) {
            output.writeLongLE(value.longValue());
        }
    }

    protected static class DWORD2FloatLE
    extends BasicField<Float> {
        protected DWORD2FloatLE() {
        }

        @Override
        public void readAndSet(ByteBuf input, Object obj) throws Exception {
            this.f.setFloat(obj, input.readFloatLE());
        }

        @Override
        public void getAndWrite(ByteBuf output, Object obj) throws Exception {
            output.writeFloatLE(this.f.getFloat(obj));
        }

        @Override
        public Float readFrom(ByteBuf input) {
            return Float.valueOf(input.readFloatLE());
        }

        @Override
        public void writeTo(ByteBuf output, Float value) {
            output.writeFloatLE(value.floatValue());
        }
    }

    protected static class DWORD2LongLE
    extends BasicField<Long> {
        protected DWORD2LongLE() {
        }

        @Override
        public void readAndSet(ByteBuf input, Object obj) throws Exception {
            this.f.setLong(obj, input.readUnsignedIntLE());
        }

        @Override
        public void getAndWrite(ByteBuf output, Object obj) throws Exception {
            output.writeIntLE((int)this.f.getLong(obj));
        }

        @Override
        public Long readFrom(ByteBuf input) {
            return input.readUnsignedIntLE();
        }

        @Override
        public void writeTo(ByteBuf output, Long value) {
            output.writeIntLE(value.intValue());
        }
    }

    protected static class DWORD2IntLE
    extends BasicField<Integer> {
        protected DWORD2IntLE() {
        }

        @Override
        public void readAndSet(ByteBuf input, Object obj) throws Exception {
            this.f.setInt(obj, input.readIntLE());
        }

        @Override
        public void getAndWrite(ByteBuf output, Object obj) throws Exception {
            output.writeIntLE(this.f.getInt(obj));
        }

        @Override
        public Integer readFrom(ByteBuf input) {
            return input.readIntLE();
        }

        @Override
        public void writeTo(ByteBuf output, Integer value) {
            output.writeIntLE(value.intValue());
        }
    }

    protected static class WORD2IntLE
    extends BasicField<Integer> {
        protected WORD2IntLE() {
        }

        @Override
        public void readAndSet(ByteBuf input, Object obj) throws Exception {
            this.f.setInt(obj, input.readUnsignedShortLE());
        }

        @Override
        public void getAndWrite(ByteBuf output, Object obj) throws Exception {
            output.writeShortLE(this.f.getInt(obj));
        }

        @Override
        public Integer readFrom(ByteBuf input) {
            return input.readUnsignedShortLE();
        }

        @Override
        public void writeTo(ByteBuf output, Integer value) {
            output.writeShortLE(value.intValue());
        }
    }

    protected static class WORD2ShortLE
    extends BasicField<Short> {
        protected WORD2ShortLE() {
        }

        @Override
        public void readAndSet(ByteBuf input, Object obj) throws Exception {
            this.f.setShort(obj, input.readShortLE());
        }

        @Override
        public void getAndWrite(ByteBuf output, Object obj) throws Exception {
            output.writeShortLE((int)this.f.getShort(obj));
        }

        @Override
        public Short readFrom(ByteBuf input) {
            return input.readShortLE();
        }

        @Override
        public void writeTo(ByteBuf output, Short value) {
            output.writeShortLE((int)value.shortValue());
        }
    }

    protected static class QWORD2Double
    extends BasicField<Double> {
        protected QWORD2Double() {
        }

        @Override
        public void readAndSet(ByteBuf input, Object obj) throws Exception {
            this.f.setDouble(obj, input.readDouble());
        }

        @Override
        public void getAndWrite(ByteBuf output, Object obj) throws Exception {
            output.writeDouble(this.f.getDouble(obj));
        }

        @Override
        public Double readFrom(ByteBuf input) {
            return input.readDouble();
        }

        @Override
        public void writeTo(ByteBuf output, Double value) {
            output.writeDouble(value.doubleValue());
        }
    }

    protected static class QWORD2Long
    extends BasicField<Long> {
        protected QWORD2Long() {
        }

        @Override
        public void readAndSet(ByteBuf input, Object obj) throws Exception {
            this.f.setLong(obj, input.readLong());
        }

        @Override
        public void getAndWrite(ByteBuf output, Object obj) throws Exception {
            output.writeLong(this.f.getLong(obj));
        }

        @Override
        public Long readFrom(ByteBuf input) {
            return input.readLong();
        }

        @Override
        public void writeTo(ByteBuf output, Long value) {
            output.writeLong(value.longValue());
        }
    }

    protected static class DWORD2Float
    extends BasicField<Float> {
        protected DWORD2Float() {
        }

        @Override
        public void readAndSet(ByteBuf input, Object obj) throws Exception {
            this.f.setFloat(obj, input.readFloat());
        }

        @Override
        public void getAndWrite(ByteBuf output, Object obj) throws Exception {
            output.writeFloat(this.f.getFloat(obj));
        }

        @Override
        public Float readFrom(ByteBuf input) {
            return Float.valueOf(input.readFloat());
        }

        @Override
        public void writeTo(ByteBuf output, Float value) {
            output.writeFloat(value.floatValue());
        }
    }

    protected static class DWORD2Long
    extends BasicField<Long> {
        protected DWORD2Long() {
        }

        @Override
        public void readAndSet(ByteBuf input, Object obj) throws Exception {
            this.f.setLong(obj, input.readUnsignedInt());
        }

        @Override
        public void getAndWrite(ByteBuf output, Object obj) throws Exception {
            output.writeInt((int)this.f.getLong(obj));
        }

        @Override
        public Long readFrom(ByteBuf input) {
            return input.readUnsignedInt();
        }

        @Override
        public void writeTo(ByteBuf output, Long value) {
            output.writeInt(value.intValue());
        }
    }

    protected static class DWORD2Int
    extends BasicField<Integer> {
        protected DWORD2Int() {
        }

        @Override
        public void readAndSet(ByteBuf input, Object obj) throws Exception {
            this.f.setInt(obj, input.readInt());
        }

        @Override
        public void getAndWrite(ByteBuf output, Object obj) throws Exception {
            output.writeInt(this.f.getInt(obj));
        }

        @Override
        public Integer readFrom(ByteBuf input) {
            return input.readInt();
        }

        @Override
        public void writeTo(ByteBuf output, Integer value) {
            output.writeInt(value.intValue());
        }
    }

    protected static class WORD2Int
    extends BasicField<Integer> {
        protected WORD2Int() {
        }

        @Override
        public void readAndSet(ByteBuf input, Object obj) throws Exception {
            this.f.setInt(obj, input.readUnsignedShort());
        }

        @Override
        public void getAndWrite(ByteBuf output, Object obj) throws Exception {
            output.writeShort(this.f.getInt(obj));
        }

        @Override
        public Integer readFrom(ByteBuf input) {
            return input.readUnsignedShort();
        }

        @Override
        public void writeTo(ByteBuf output, Integer value) {
            output.writeShort(value.intValue());
        }
    }

    protected static class WORD2Short
    extends BasicField<Short> {
        protected WORD2Short() {
        }

        @Override
        public void readAndSet(ByteBuf input, Object obj) throws Exception {
            this.f.setShort(obj, input.readShort());
        }

        @Override
        public void getAndWrite(ByteBuf output, Object obj) throws Exception {
            output.writeShort((int)this.f.getShort(obj));
        }

        @Override
        public Short readFrom(ByteBuf input) {
            return input.readShort();
        }

        @Override
        public void writeTo(ByteBuf output, Short value) {
            output.writeShort((int)value.shortValue());
        }
    }

    protected static class BYTE2Int
    extends BasicField<Integer> {
        protected BYTE2Int() {
        }

        @Override
        public void readAndSet(ByteBuf input, Object obj) throws Exception {
            this.f.setInt(obj, input.readUnsignedByte());
        }

        @Override
        public void getAndWrite(ByteBuf output, Object obj) throws Exception {
            output.writeByte(this.f.getInt(obj));
        }

        @Override
        public Integer readFrom(ByteBuf input) {
            return input.readUnsignedByte();
        }

        @Override
        public void writeTo(ByteBuf output, Integer value) {
            output.writeByte(value.intValue());
        }
    }

    protected static class BYTE2Short
    extends BasicField<Short> {
        protected BYTE2Short() {
        }

        @Override
        public void readAndSet(ByteBuf input, Object obj) throws Exception {
            this.f.setShort(obj, input.readUnsignedByte());
        }

        @Override
        public void getAndWrite(ByteBuf output, Object obj) throws Exception {
            output.writeByte((int)this.f.getShort(obj));
        }

        @Override
        public Short readFrom(ByteBuf input) {
            return input.readUnsignedByte();
        }

        @Override
        public void writeTo(ByteBuf output, Short value) {
            output.writeByte((int)value.shortValue());
        }
    }

    protected static class BYTE2Byte
    extends BasicField<Byte> {
        protected BYTE2Byte() {
        }

        @Override
        public void readAndSet(ByteBuf input, Object obj) throws Exception {
            this.f.setByte(obj, input.readByte());
        }

        @Override
        public void getAndWrite(ByteBuf output, Object obj) throws Exception {
            output.writeByte((int)this.f.getByte(obj));
        }

        @Override
        public Byte readFrom(ByteBuf input) {
            return input.readByte();
        }

        @Override
        public void writeTo(ByteBuf output, Byte value) {
            output.writeByte((int)value.byteValue());
        }
    }

    protected static class CHAR
    extends BasicField<Character> {
        protected CHAR() {
        }

        @Override
        public void readAndSet(ByteBuf input, Object obj) throws Exception {
            this.f.setChar(obj, input.readChar());
        }

        @Override
        public void getAndWrite(ByteBuf output, Object obj) throws Exception {
            output.writeChar((int)this.f.getChar(obj));
        }

        @Override
        public Character readFrom(ByteBuf input) {
            return Character.valueOf(input.readChar());
        }

        @Override
        public void writeTo(ByteBuf output, Character value) {
            output.writeChar((int)value.charValue());
        }
    }

    protected static class BOOL
    extends BasicField<Boolean> {
        protected BOOL() {
        }

        @Override
        public void readAndSet(ByteBuf input, Object obj) throws Exception {
            this.f.setBoolean(obj, input.readBoolean());
        }

        @Override
        public void getAndWrite(ByteBuf output, Object obj) throws Exception {
            output.writeBoolean(this.f.getBoolean(obj));
        }

        @Override
        public Boolean readFrom(ByteBuf input) {
            return input.readBoolean();
        }

        @Override
        public void writeTo(ByteBuf output, Boolean value) {
            output.writeBoolean(value.booleanValue());
        }
    }
}

