/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.protostar.schema;

import io.github.yezhihao.protostar.PrepareLoadStrategy;
import io.github.yezhihao.protostar.Schema;
import io.github.yezhihao.protostar.field.BasicField;
import io.github.yezhihao.protostar.util.IntTool;
import io.github.yezhihao.protostar.util.KeyValuePair;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MapSchema<K, V>
extends BasicField<Map.Entry<K, V>> {
    public final Logger log = LoggerFactory.getLogger((String)this.getClass().getSimpleName());
    public final Schema<K> keySchema;
    public final int lengthUnit;
    public final IntTool intTool;
    public final Map<K, Schema> valueSchema;

    public MapSchema(Schema<K> keySchema, int lengthUnit) {
        this.keySchema = keySchema;
        this.lengthUnit = lengthUnit;
        this.intTool = IntTool.getInstance(lengthUnit);
        PrepareLoadStrategy loadStrategy = new PrepareLoadStrategy();
        this.addSchemas(loadStrategy);
        this.valueSchema = loadStrategy.build();
    }

    protected abstract void addSchemas(PrepareLoadStrategy<K> var1);

    @Override
    public KeyValuePair<K, V> readFrom(ByteBuf input) {
        K key = this.keySchema.readFrom(input);
        KeyValuePair<K, Object> result = new KeyValuePair<K, Object>(key);
        int length = this.intTool.read(input);
        if (length > 0) {
            int writerIndex = input.writerIndex();
            input.writerIndex(input.readerIndex() + length);
            Schema schema = this.valueSchema.get(key);
            if (schema != null) {
                Object value = schema.readFrom(input, length);
                result.setValue(value);
            } else {
                byte[] bytes = new byte[length];
                input.readBytes(bytes);
                result.setValue(bytes);
            }
            input.writerIndex(writerIndex);
        } else if (length < 0) {
            Schema schema = this.valueSchema.get(key);
            if (schema != null) {
                Object value = schema.readFrom(input);
                result.setValue(value);
            } else {
                byte[] bytes = new byte[input.readableBytes()];
                input.readBytes(bytes);
                result.setValue(bytes);
            }
        }
        return result;
    }

    @Override
    public void writeTo(ByteBuf output, Map.Entry<K, V> entry) {
        if (entry == null) {
            return;
        }
        K key = entry.getKey();
        this.keySchema.writeTo(output, key);
        Schema schema = this.valueSchema.get(key);
        if (schema != null) {
            int begin = output.writerIndex();
            this.intTool.write(output, 0);
            V value = entry.getValue();
            if (value != null) {
                schema.writeTo(output, value);
                int length = output.writerIndex() - begin - this.lengthUnit;
                this.intTool.set(output, begin, length);
            }
        } else {
            this.log.warn("\u672a\u6ce8\u518c\u7684\u4fe1\u606f:ID[{}], Value[{}]", key, entry.getValue());
        }
    }
}

