/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.protostar.field;

import io.github.yezhihao.protostar.Schema;
import io.github.yezhihao.protostar.field.BasicField;
import io.github.yezhihao.protostar.schema.MapSchema;
import io.github.yezhihao.protostar.util.Explain;
import io.github.yezhihao.protostar.util.Info;
import io.github.yezhihao.protostar.util.IntTool;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TotalMapField<K, V>
extends BasicField<Map<K, V>> {
    private static final Logger log = LoggerFactory.getLogger((String)TotalMapField.class.getSimpleName());
    private final Schema<K> keySchema;
    private final Map<K, Schema<V>> valueSchema;
    private final int lengthUnit;
    private final IntTool valueIntTool;
    private final int totalUnit;
    private final IntTool totalIntTool;
    private final boolean treeMap;

    public TotalMapField(MapSchema mapSchema, int totalUnit, Class typeClass) {
        this.keySchema = mapSchema.keySchema;
        this.valueSchema = mapSchema.valueSchema;
        this.lengthUnit = mapSchema.lengthUnit;
        this.valueIntTool = mapSchema.intTool;
        this.totalUnit = totalUnit;
        this.totalIntTool = IntTool.getInstance(totalUnit);
        this.treeMap = !HashMap.class.isAssignableFrom(typeClass);
    }

    @Override
    public Map<K, V> readFrom(ByteBuf input) {
        if (!input.isReadable()) {
            return null;
        }
        int total = this.totalIntTool.read(input);
        if (total <= 0) {
            return null;
        }
        AbstractMap map = this.treeMap ? new TreeMap() : new HashMap((int)((double)total / 0.75) + 1);
        Object key = null;
        int length = 0;
        try {
            for (int i = 0; i < total; ++i) {
                Object value;
                int readerIndex;
                key = this.keySchema.readFrom(input);
                length = this.valueIntTool.read(input);
                if (length <= 0) continue;
                int writerIndex = input.writerIndex();
                if (writerIndex > (readerIndex = input.readerIndex() + length)) {
                    input.writerIndex(readerIndex);
                    value = this.readValue(key, input);
                    map.put(key, value);
                    input.setIndex(readerIndex, writerIndex);
                    continue;
                }
                value = this.readValue(key, input);
                map.put(key, value);
                break;
            }
        }
        catch (Exception e) {
            log.warn("\u89e3\u6790\u51fa\u9519:ID[{}], LENGTH[{}], {}", new Object[]{key, length, e.getMessage()});
        }
        return map;
    }

    public Object readValue(Object key, ByteBuf input) {
        Schema<V> schema = this.valueSchema.get(key);
        if (schema != null) {
            return schema.readFrom(input);
        }
        byte[] bytes = new byte[input.readableBytes()];
        input.readBytes(bytes);
        return bytes;
    }

    @Override
    public void writeTo(ByteBuf output, Map<K, V> map) {
        if (map == null) {
            return;
        }
        this.totalIntTool.write(output, map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            this.keySchema.writeTo(output, key);
            V value = entry.getValue();
            Schema<V> schema = this.valueSchema.get(key);
            if (schema != null) {
                int begin = output.writerIndex();
                this.valueIntTool.write(output, 0);
                schema.writeTo(output, value);
                int length = output.writerIndex() - begin - this.lengthUnit;
                this.valueIntTool.set(output, begin, length);
                continue;
            }
            log.warn("\u672a\u6ce8\u518c\u7684\u4fe1\u606f:ID[{}], VALUE[{}]", key, value);
        }
    }

    @Override
    public Map<K, V> readFrom(ByteBuf input, Explain explain) {
        if (!input.isReadable()) {
            return null;
        }
        int total = this.totalIntTool.read(input);
        explain.lengthField(input.readerIndex() - this.totalUnit, this.desc + "\u6570\u91cf", total, this.totalUnit);
        if (total <= 0) {
            return null;
        }
        AbstractMap map = this.treeMap ? new TreeMap() : new HashMap((int)((double)total / 0.75) + 1);
        Object key = null;
        int length = 0;
        try {
            for (int i = 0; i < total; ++i) {
                Object value;
                int readerIndex;
                key = this.keySchema.readFrom(input, explain);
                explain.setLastDesc(this.desc + "ID");
                length = this.valueIntTool.read(input);
                explain.lengthField(input.readerIndex() - this.lengthUnit, this.desc + "\u957f\u5ea6", length, this.lengthUnit);
                if (length <= 0) continue;
                int writerIndex = input.writerIndex();
                if (writerIndex > (readerIndex = input.readerIndex() + length)) {
                    input.writerIndex(readerIndex);
                    value = this.readValue(key, input, explain);
                    map.put(key, value);
                    input.setIndex(readerIndex, writerIndex);
                    continue;
                }
                value = this.readValue(key, input, explain);
                map.put(key, value);
                break;
            }
        }
        catch (Exception e) {
            log.warn("\u89e3\u6790\u51fa\u9519:ID[{}], LENGTH[{}], {}", new Object[]{key, length, e.getMessage()});
        }
        return map;
    }

    public Object readValue(Object key, ByteBuf input, Explain explain) {
        Schema<V> schema = this.valueSchema.get(key);
        if (schema != null) {
            V value = schema.readFrom(input, explain);
            return value;
        }
        int begin = input.readerIndex();
        byte[] bytes = new byte[input.readableBytes()];
        input.readBytes(bytes);
        explain.readField(begin, this.desc, ByteBufUtil.hexDump((byte[])bytes), input);
        return bytes;
    }

    @Override
    public void writeTo(ByteBuf output, Map<K, V> map, Explain explain) {
        if (map == null) {
            return;
        }
        this.totalIntTool.write(output, map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            this.keySchema.writeTo(output, key, explain);
            explain.setLastDesc(this.desc + "ID");
            V value = entry.getValue();
            Schema<V> schema = this.valueSchema.get(key);
            if (schema != null) {
                int begin = output.writerIndex();
                Info info = explain.lengthField(begin, this.desc + "\u957f\u5ea6", 0, this.lengthUnit);
                this.valueIntTool.write(output, 0);
                schema.writeTo(output, value, explain);
                int length = output.writerIndex() - begin - this.lengthUnit;
                this.valueIntTool.set(output, begin, length);
                info.setLength(length, this.lengthUnit);
                continue;
            }
            log.warn("\u672a\u6ce8\u518c\u7684\u4fe1\u606f:ID[{}], VALUE[{}]", key, value);
        }
    }
}

