/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.protostar.field;

import io.github.yezhihao.protostar.Schema;
import io.github.yezhihao.protostar.field.BasicField;
import io.github.yezhihao.protostar.util.Explain;
import io.github.yezhihao.protostar.util.IntTool;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;

public class TotalCollectionField<T>
extends BasicField<Collection<T>> {
    private final Schema<T> schema;
    private final int totalUnit;
    private final IntTool intTool;

    public TotalCollectionField(Schema<T> schema, int totalUnit) {
        this.schema = schema;
        this.totalUnit = totalUnit;
        this.intTool = IntTool.getInstance(totalUnit);
    }

    @Override
    public Collection<T> readFrom(ByteBuf input) {
        int total = this.intTool.read(input);
        if (total <= 0) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>(total);
        for (int i = 0; i < total; ++i) {
            T t = this.schema.readFrom(input);
            list.add(t);
        }
        return list;
    }

    @Override
    public void writeTo(ByteBuf output, Collection<T> list) {
        if (list != null) {
            this.intTool.write(output, list.size());
            for (T t : list) {
                this.schema.writeTo(output, t);
            }
        } else {
            this.intTool.write(output, 0);
        }
    }

    @Override
    public Collection<T> readFrom(ByteBuf input, Explain explain) {
        int total = this.intTool.read(input);
        explain.lengthField(input.readerIndex() - this.totalUnit, this.desc + "\u6570\u91cf", total, this.totalUnit);
        if (total <= 0) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>(total);
        for (int i = 0; i < total; ++i) {
            T t = this.schema.readFrom(input, explain);
            list.add(t);
        }
        return list;
    }

    @Override
    public void writeTo(ByteBuf output, Collection<T> list, Explain explain) {
        if (list != null) {
            int total = list.size();
            explain.lengthField(output.writerIndex(), this.desc + "\u6570\u91cf", total, this.totalUnit);
            this.intTool.write(output, total);
            for (T t : list) {
                this.schema.writeTo(output, t, explain);
            }
        } else {
            explain.lengthField(output.writerIndex(), this.desc + "\u6570\u91cf", 0, this.totalUnit);
            this.intTool.write(output, 0);
        }
    }
}

