/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.protostar.field;

import io.github.yezhihao.protostar.Schema;
import io.github.yezhihao.protostar.field.BasicField;
import io.github.yezhihao.protostar.schema.SchemaRegistry;
import io.github.yezhihao.protostar.util.Explain;
import io.github.yezhihao.protostar.util.IntTool;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Array;

public class TotalArrayPrimitiveField
extends BasicField {
    private final Schema schema;
    private final int totalUnit;
    private final int valueUnit;
    private final IntTool intTool;

    public TotalArrayPrimitiveField(Schema schema, int totalUnit, Class arrayClass) {
        this.schema = schema;
        this.totalUnit = totalUnit;
        this.valueUnit = SchemaRegistry.getLength(arrayClass);
        this.intTool = IntTool.getInstance(totalUnit);
    }

    @Override
    public Object readFrom(ByteBuf input) {
        int total = this.intTool.read(input);
        if (total <= 0) {
            return null;
        }
        int length = this.valueUnit * total;
        return this.schema.readFrom(input, length);
    }

    @Override
    public void writeTo(ByteBuf output, Object value) {
        if (value == null) {
            this.intTool.write(output, 0);
        } else {
            int total = Array.getLength(value);
            this.intTool.write(output, total);
            this.schema.writeTo(output, value);
        }
    }

    @Override
    public Object readFrom(ByteBuf input, Explain explain) {
        int total = this.intTool.read(input);
        explain.lengthField(input.readerIndex() - this.totalUnit, this.desc + "\u6570\u91cf", total, this.totalUnit);
        if (total <= 0) {
            return null;
        }
        int length = this.valueUnit * total;
        return this.schema.readFrom(input, length, explain);
    }

    @Override
    public void writeTo(ByteBuf output, Object value, Explain explain) {
        if (value == null) {
            explain.lengthField(output.writerIndex(), this.desc + "\u6570\u91cf", 0, this.totalUnit);
            this.intTool.write(output, 0);
        } else {
            int total = Array.getLength(value);
            explain.lengthField(output.writerIndex(), this.desc + "\u6570\u91cf", total, this.totalUnit);
            this.intTool.write(output, total);
            this.schema.writeTo(output, value, explain);
        }
    }
}

