/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.protostar.field;

import io.github.yezhihao.protostar.Schema;
import io.github.yezhihao.protostar.field.BasicField;
import io.github.yezhihao.protostar.util.Explain;
import io.github.yezhihao.protostar.util.IntTool;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Array;

public class TotalArrayObjectField<T>
extends BasicField<T[]> {
    private final Schema<T> schema;
    private final int totalUnit;
    private final IntTool intTool;
    private final Class<T> arrayClass;

    public TotalArrayObjectField(Schema<T> schema, int totalUnit, Class<T> arrayClass) {
        this.schema = schema;
        this.totalUnit = totalUnit;
        this.intTool = IntTool.getInstance(totalUnit);
        this.arrayClass = arrayClass;
    }

    @Override
    public T[] readFrom(ByteBuf input) {
        int total = this.intTool.read(input);
        if (total <= 0) {
            return null;
        }
        Object[] value = (Object[])Array.newInstance(this.arrayClass, total);
        for (int i = 0; i < total; ++i) {
            T t = this.schema.readFrom(input);
            value[i] = t;
        }
        return value;
    }

    @Override
    public void writeTo(ByteBuf output, T[] value) {
        if (value == null) {
            this.intTool.write(output, 0);
        } else {
            int length = value.length;
            this.intTool.write(output, length);
            for (int i = 0; i < length; ++i) {
                T t = value[i];
                this.schema.writeTo(output, t);
            }
        }
    }

    @Override
    public T[] readFrom(ByteBuf input, Explain explain) {
        int total = this.intTool.read(input);
        explain.lengthField(input.readerIndex() - this.totalUnit, this.desc + "\u6570\u91cf", total, this.totalUnit);
        if (total <= 0) {
            return null;
        }
        Object[] value = (Object[])Array.newInstance(this.arrayClass, total);
        for (int i = 0; i < total; ++i) {
            T t = this.schema.readFrom(input, explain);
            value[i] = t;
        }
        return value;
    }

    @Override
    public void writeTo(ByteBuf output, T[] value, Explain explain) {
        if (value == null) {
            explain.lengthField(output.writerIndex(), this.desc + "\u6570\u91cf", 0, this.totalUnit);
            this.intTool.write(output, 0);
        } else {
            int total = value.length;
            explain.lengthField(output.writerIndex(), this.desc + "\u6570\u91cf", total, this.totalUnit);
            this.intTool.write(output, total);
            for (int i = 0; i < total; ++i) {
                T t = value[i];
                this.schema.writeTo(output, t, explain);
            }
        }
    }
}

