/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.protostar.field;

import io.github.yezhihao.protostar.Schema;
import io.github.yezhihao.protostar.field.BasicField;
import io.github.yezhihao.protostar.util.Explain;
import io.github.yezhihao.protostar.util.Info;
import io.github.yezhihao.protostar.util.IntTool;
import io.netty.buffer.ByteBuf;

public class LengthUnitField<T>
extends BasicField<T> {
    private final Schema<T> schema;
    private final int lengthUnit;
    private final IntTool intTool;

    public LengthUnitField(Schema<T> schema, int lengthUnit) {
        this.schema = schema;
        this.lengthUnit = lengthUnit;
        this.intTool = IntTool.getInstance(lengthUnit);
    }

    @Override
    public T readFrom(ByteBuf input) {
        int length = this.intTool.read(input);
        return this.schema.readFrom(input, length);
    }

    @Override
    public void writeTo(ByteBuf output, T value) {
        int begin = output.writerIndex();
        this.intTool.write(output, 0);
        if (value != null) {
            this.schema.writeTo(output, value);
            int length = output.writerIndex() - begin - this.lengthUnit;
            this.intTool.set(output, begin, length);
        }
    }

    @Override
    public T readFrom(ByteBuf input, Explain explain) {
        int length = this.intTool.read(input);
        explain.lengthField(input.readerIndex() - this.lengthUnit, this.desc + "\u957f\u5ea6", length, this.lengthUnit);
        T value = this.schema.readFrom(input, length, explain);
        explain.setLastDesc(this.desc);
        return value;
    }

    @Override
    public void writeTo(ByteBuf output, T value, Explain explain) {
        int begin = output.writerIndex();
        Info info = explain.lengthField(begin, this.desc + "\u957f\u5ea6", 0, this.lengthUnit);
        this.intTool.write(output, 0);
        if (value != null) {
            this.schema.writeTo(output, value, explain);
            explain.setLastDesc(this.desc);
            int length = output.writerIndex() - begin - this.lengthUnit;
            this.intTool.set(output, begin, length);
            info.setLength(length, this.lengthUnit);
        }
    }
}

