/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.protostar.field;

import io.github.yezhihao.protostar.Schema;
import io.github.yezhihao.protostar.field.BasicField;
import io.github.yezhihao.protostar.util.Explain;
import io.github.yezhihao.protostar.util.Info;
import io.github.yezhihao.protostar.util.IntTool;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;

public class LengthUnitCollectionField<T>
extends BasicField<Collection<T>> {
    private final Schema<T> schema;
    private final int lengthUnit;
    private final IntTool intTool;

    public LengthUnitCollectionField(Schema<T> schema, int lengthUnit) {
        this.schema = schema;
        this.lengthUnit = lengthUnit;
        this.intTool = IntTool.getInstance(lengthUnit);
    }

    @Override
    public Collection<T> readFrom(ByteBuf input) {
        ArrayList<T> list = new ArrayList<T>();
        while (input.isReadable()) {
            int length = this.intTool.read(input);
            T t = this.schema.readFrom(input, length);
            list.add(t);
        }
        return list;
    }

    @Override
    public void writeTo(ByteBuf output, Collection<T> list) {
        if (list != null) {
            for (T t : list) {
                if (t == null) continue;
                int begin = output.writerIndex();
                this.intTool.write(output, 0);
                this.schema.writeTo(output, t);
                int length = output.writerIndex() - begin - this.lengthUnit;
                this.intTool.set(output, begin, length);
            }
        }
    }

    @Override
    public Collection<T> readFrom(ByteBuf input, Explain explain) {
        ArrayList<T> list = new ArrayList<T>();
        while (input.isReadable()) {
            int length = this.intTool.read(input);
            explain.lengthField(input.readerIndex() - this.lengthUnit, this.desc + "\u957f\u5ea6", length, this.lengthUnit);
            T t = this.schema.readFrom(input, length, explain);
            list.add(t);
        }
        return list;
    }

    @Override
    public void writeTo(ByteBuf output, Collection<T> list, Explain explain) {
        if (list != null) {
            for (T t : list) {
                if (t == null) continue;
                int begin = output.writerIndex();
                Info info = explain.lengthField(begin, this.desc + "\u957f\u5ea6", 0, this.lengthUnit);
                this.intTool.write(output, 0);
                this.schema.writeTo(output, t, explain);
                int length = output.writerIndex() - begin - this.lengthUnit;
                this.intTool.set(output, begin, length);
                info.setLength(length, this.lengthUnit);
            }
        }
    }
}

