/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.protostar.field;

import io.github.yezhihao.protostar.Schema;
import io.github.yezhihao.protostar.field.BasicField;
import io.github.yezhihao.protostar.util.Explain;
import io.netty.buffer.ByteBuf;

public class LengthField<T>
extends BasicField<T> {
    private final Schema<T> schema;
    private final int length;

    public LengthField(Schema<T> schema, int length) {
        this.schema = schema;
        this.length = length;
    }

    @Override
    public T readFrom(ByteBuf input) {
        if (input.isReadable(this.length)) {
            return this.schema.readFrom(input, this.length);
        }
        return null;
    }

    @Override
    public void writeTo(ByteBuf output, T value) {
        if (value != null) {
            this.schema.writeTo(output, this.length, value);
        }
    }

    @Override
    public T readFrom(ByteBuf input, Explain explain) {
        if (input.isReadable(this.length)) {
            return this.schema.readFrom(input, this.length, explain);
        }
        return null;
    }

    @Override
    public void writeTo(ByteBuf output, T value, Explain explain) {
        if (value != null) {
            this.schema.writeTo(output, this.length, value, explain);
        }
    }
}

