/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.protostar.field;

import io.github.yezhihao.protostar.Schema;
import io.github.yezhihao.protostar.field.BasicField;
import io.github.yezhihao.protostar.util.Explain;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;

public class CollectionField<T>
extends BasicField<Collection<T>> {
    private final Schema<T> schema;

    public CollectionField(Schema<T> schema) {
        this.schema = schema;
    }

    @Override
    public Collection<T> readFrom(ByteBuf input) {
        ArrayList<T> list = new ArrayList<T>();
        while (input.isReadable()) {
            T t = this.schema.readFrom(input);
            list.add(t);
        }
        return list;
    }

    @Override
    public void writeTo(ByteBuf output, Collection<T> list) {
        if (list != null) {
            for (T t : list) {
                this.schema.writeTo(output, t);
            }
        }
    }

    @Override
    public Collection<T> readFrom(ByteBuf input, Explain explain) {
        ArrayList<T> list = new ArrayList<T>();
        while (input.isReadable()) {
            T t = this.schema.readFrom(input, explain);
            list.add(t);
        }
        return list;
    }

    @Override
    public void writeTo(ByteBuf output, Collection<T> list, Explain explain) {
        if (list != null) {
            for (T t : list) {
                this.schema.writeTo(output, t, explain);
            }
        }
    }
}

