/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.protostar.field;

import io.github.yezhihao.protostar.Schema;
import io.github.yezhihao.protostar.schema.SchemaRegistry;
import io.github.yezhihao.protostar.util.Explain;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;

public abstract class BasicField<T>
implements Schema<T>,
Comparable<BasicField> {
    protected Field f;
    protected io.github.yezhihao.protostar.annotation.Field field;
    protected int index;
    protected int length;
    protected String desc;

    public void readAndSet(ByteBuf input, Object obj) throws Exception {
        Object value = this.readFrom(input);
        this.f.set(obj, value);
    }

    public void getAndWrite(ByteBuf output, Object obj) throws Exception {
        Object value = this.f.get(obj);
        this.writeTo(output, value);
    }

    public void readAndSet(ByteBuf input, Object obj, Explain explain) throws Exception {
        Object value = this.readFrom(input, explain);
        this.f.set(obj, value);
    }

    public void getAndWrite(ByteBuf output, Object obj, Explain explain) throws Exception {
        Object value = this.f.get(obj);
        this.writeTo(output, value, explain);
    }

    public BasicField init(io.github.yezhihao.protostar.annotation.Field field, Field f, int position) {
        if (this.f == null && this.field == null) {
            this.f = f;
            this.field = field;
            this.length = field.length() > 0 ? field.length() : SchemaRegistry.getLength(f.getType());
            this.length = this.length > 0 ? this.length : 16;
            this.desc = field.desc();
            if (this.desc.isEmpty()) {
                this.desc = f.getName();
            }
            this.index = field.index();
            if (this.index == 0) {
                this.index = position;
            }
        }
        return this;
    }

    public String fieldName() {
        return this.f.getName();
    }

    @Override
    public String desc() {
        return this.desc;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public int compareTo(BasicField that) {
        return Integer.compare(this.index, that.index);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BasicField)) {
            return false;
        }
        BasicField that = (BasicField)other;
        return this.f.equals(that.f);
    }

    public int hashCode() {
        return this.f.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(12);
        sb.append(this.desc).append(' ').append(this.field);
        return sb.toString();
    }
}

