/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.protostar;

import io.github.yezhihao.protostar.ProtostarUtil;
import io.github.yezhihao.protostar.annotation.Message;
import io.github.yezhihao.protostar.schema.RuntimeSchema;
import io.github.yezhihao.protostar.util.ArrayMap;
import io.github.yezhihao.protostar.util.ClassUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SchemaManager {
    private final Map<Integer, ArrayMap<RuntimeSchema>> typeIdMapping;
    private final Map<String, ArrayMap<RuntimeSchema>> typeClassMapping;

    public SchemaManager() {
        this(128);
    }

    public SchemaManager(int initialCapacity) {
        this.typeIdMapping = new HashMap<Integer, ArrayMap<RuntimeSchema>>(initialCapacity);
        this.typeClassMapping = new HashMap<String, ArrayMap<RuntimeSchema>>(initialCapacity);
    }

    public SchemaManager(String ... basePackages) {
        this(256, basePackages);
    }

    public SchemaManager(int initialCapacity, String ... basePackages) {
        this(initialCapacity);
        for (String basePackage : basePackages) {
            List<Class> types = ClassUtils.getClassList(basePackage);
            for (Class type : types) {
                int[] values;
                Message message = type.getAnnotation(Message.class);
                if (message == null) continue;
                int[] nArray = values = message.value();
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer typeId = nArray[i];
                    this.loadRuntimeSchema(typeId, type);
                }
            }
        }
    }

    public void loadRuntimeSchema(Integer typeId, Class typeClass) {
        ArrayMap<RuntimeSchema> schemaMap = ProtostarUtil.getRuntimeSchema(this.typeClassMapping, typeClass);
        if (schemaMap != null) {
            this.typeIdMapping.put(typeId, schemaMap);
        }
    }

    public <T> RuntimeSchema<T> getRuntimeSchema(Class<T> typeClass, int version) {
        ArrayMap<RuntimeSchema> schemaMap = ProtostarUtil.getRuntimeSchema(this.typeClassMapping, typeClass);
        if (schemaMap == null) {
            return null;
        }
        return schemaMap.getOrDefault(version);
    }

    public ArrayMap<RuntimeSchema> getRuntimeSchema(Class typeClass) {
        return ProtostarUtil.getRuntimeSchema(this.typeClassMapping, typeClass);
    }

    public RuntimeSchema getRuntimeSchema(Integer typeId, int version) {
        ArrayMap<RuntimeSchema> schemaMap = this.typeIdMapping.get(typeId);
        if (schemaMap == null) {
            return null;
        }
        return schemaMap.getOrDefault(version);
    }

    public ArrayMap<RuntimeSchema> getRuntimeSchema(Integer typeId) {
        return this.typeIdMapping.get(typeId);
    }
}

