/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.protostar;

import io.github.yezhihao.protostar.util.Explain;
import io.netty.buffer.ByteBuf;

public interface Schema<T> {
    public T readFrom(ByteBuf var1);

    public void writeTo(ByteBuf var1, T var2);

    default public T readFrom(ByteBuf input, int length) {
        int readerLength = input.readerIndex() + length;
        int writerIndex = input.writerIndex();
        input.writerIndex(readerLength);
        T value = this.readFrom(input);
        input.setIndex(readerLength, writerIndex);
        return value;
    }

    default public void writeTo(ByteBuf output, int length, T value) {
        int writerLength = output.writerIndex() + length;
        this.writeTo(output, value);
        output.writerIndex(writerLength);
    }

    default public T readFrom(ByteBuf input, Explain explain) {
        int begin = input.readerIndex();
        T value = this.readFrom(input);
        explain.readField(begin, this.desc(), value, input);
        return value;
    }

    default public void writeTo(ByteBuf output, T value, Explain explain) {
        int begin = output.writerIndex();
        this.writeTo(output, value);
        explain.writeField(begin, this.desc(), value, output);
    }

    default public T readFrom(ByteBuf input, int length, Explain explain) {
        int readerLength = input.readerIndex() + length;
        int writerIndex = input.writerIndex();
        input.writerIndex(readerLength);
        T value = this.readFrom(input, explain);
        input.setIndex(readerLength, writerIndex);
        return value;
    }

    default public void writeTo(ByteBuf output, int length, T value, Explain explain) {
        int writerLength = output.writerIndex() + length;
        this.writeTo(output, value, explain);
        output.writerIndex(writerLength);
    }

    default public int length() {
        return 32;
    }

    default public String desc() {
        return "";
    }
}

