/*
 * Decompiled with CFR 0.152.
 */
package cn.wwwlike.vlife.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ReflectionUtils {
    private static Logger logger = LoggerFactory.getLogger(ReflectionUtils.class);

    public static List<Field> getAccessibleFieldByClass(Class objClass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Validate.notNull((Object)objClass, (String)"objClass can't be null", (Object[])new Object[0]);
        for (Class superClass = objClass; superClass != Object.class; superClass = superClass.getSuperclass()) {
            fields.addAll(Arrays.asList(superClass.getDeclaredFields()));
        }
        return fields;
    }

    public static Field getAccessibleFieldByClass(Class objClass, String fieldName) {
        Field field = null;
        Validate.notNull((Object)objClass, (String)"objClass can't be null", (Object[])new Object[0]);
        for (Class superClass = objClass; superClass != Object.class; superClass = superClass.getSuperclass()) {
            for (Field temp : Arrays.asList(superClass.getDeclaredFields())) {
                if (!temp.getName().equals(fieldName)) continue;
                return temp;
            }
        }
        return field;
    }

    public static Object invokeGetterMethod(Object obj, String propertyName) {
        String getterMethodName = "get" + StringUtils.capitalize((String)propertyName);
        return ReflectionUtils.invokeMethod(obj, getterMethodName, new Class[0], new Object[0]);
    }

    public static void invokeSetterMethod(Object obj, String propertyName, Object value) {
        ReflectionUtils.invokeSetterMethod(obj, propertyName, value, null);
    }

    public static void invokeSetterMethod(Object obj, String propertyName, Object value, Class<?> propertyType) {
        Class<?> type = propertyType != null ? propertyType : value.getClass();
        String setterMethodName = "set" + StringUtils.capitalize((String)propertyName);
        ReflectionUtils.invokeMethod(obj, setterMethodName, new Class[]{type}, new Object[]{value});
    }

    public static Object getFieldValue(Object obj, String fieldName) {
        Field field = ReflectionUtils.getAccessibleField(obj, fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + fieldName + "] on target [" + obj + "]");
        }
        Object result = null;
        try {
            result = field.get(obj);
        }
        catch (IllegalAccessException e) {
            logger.error("\u4e0d\u53ef\u80fd\u629b\u51fa\u7684\u5f02\u5e38{}", (Object)e.getMessage());
        }
        return result;
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) {
        Field field = org.springframework.util.ReflectionUtils.findField(obj.getClass(), (String)fieldName);
        field.setAccessible(true);
        if (field != null) {
            org.springframework.util.ReflectionUtils.setField((Field)field, (Object)obj, (Object)value);
        }
    }

    public static Field getAccessibleField(Object obj, String fieldName) {
        Assert.notNull((Object)obj, (String)"object\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)fieldName, (String)"fieldName");
        for (Class<?> superClass = obj.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                Field field = superClass.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    public static String getAccessibleFieldName(Object obj, String fieldName) {
        Assert.notNull((Object)obj, (String)"object\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)fieldName, (String)"fieldName");
        for (Class<?> superClass = obj.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = superClass.getDeclaredFields()) {
                if (!field.getName().toUpperCase().equals(fieldName.toUpperCase())) continue;
                return field.getName();
            }
        }
        return null;
    }

    public static Object invokeMethod(Object obj, String methodName, Class<?>[] parameterTypes, Object[] args) {
        Method method = ReflectionUtils.getAccessibleMethod(obj, methodName, parameterTypes);
        if (method == null) {
            throw new IllegalArgumentException("Could not find method [" + methodName + "] on target [" + obj + "]");
        }
        try {
            return method.invoke(obj, args);
        }
        catch (Exception e) {
            throw ReflectionUtils.convertReflectionExceptionToUnchecked(e);
        }
    }

    public static Method getAccessibleMethod(Object obj, String methodName, Class<?> ... parameterTypes) {
        Assert.notNull((Object)obj, (String)"object\u4e0d\u80fd\u4e3a\u7a7a");
        for (Class<?> superClass = obj.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                Method method = superClass.getDeclaredMethod(methodName, parameterTypes);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        return null;
    }

    public static Method findMethodByObjConstructor(Class<?> clazz, String name, @Nullable Object obj) {
        Constructor<?> constructor;
        Constructor<?>[] cons = obj.getClass().getConstructors();
        Method method = null;
        Constructor<?>[] constructorArray = cons;
        int n = constructorArray.length;
        for (int i = 0; i < n && (method = ReflectionUtils.findMethod(clazz, name, (constructor = constructorArray[i]).getParameterTypes())) == null; ++i) {
        }
        return method;
    }

    @Nullable
    public static Method findMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        Assert.notNull(clazz, (String)"Class must not be null");
        Assert.notNull((Object)name, (String)"Method name must not be null");
        for (Class<?> searchType = clazz; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.isInterface() ? searchType.getMethods() : org.springframework.util.ReflectionUtils.getDeclaredMethods(searchType)) {
                if (!name.equals(method.getName()) || !ReflectionUtils.hasSameParams(method, paramTypes)) continue;
                return method;
            }
        }
        return null;
    }

    private static boolean hasSameParams1(Method method, Class<?>[] paramTypes) {
        return paramTypes.length == method.getParameterCount() && Arrays.equals(paramTypes, method.getParameterTypes());
    }

    private static boolean hasSameParams(Method method, Class<?>[] paramTypes) {
        if (method.getParameterTypes() == null && paramTypes == null) {
            return true;
        }
        if (paramTypes.length == method.getParameterCount()) {
            int i = 0;
            for (Class<?> a : paramTypes) {
                if (!method.getParameterTypes()[i].isAssignableFrom(a)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return method.getParameterCount() == 1 && method.getParameterTypes()[0].isAssignableFrom(paramTypes.getClass());
    }

    public static <T> Class<T> getSuperClassGenricType(Class clazz) {
        return ReflectionUtils.getSuperClassGenricType(clazz, 0);
    }

    public static Class getSuperClassGenricType(Class clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            logger.warn(clazz.getSimpleName() + "'s superclass not ParameterizedType");
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            logger.warn("Index: " + index + ", Size of " + clazz.getSimpleName() + "'s Parameterized Type: " + params.length);
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            logger.warn(clazz.getSimpleName() + " not set the actual class on superclass generic parameter");
            return Object.class;
        }
        return (Class)params[index];
    }

    public static RuntimeException convertReflectionExceptionToUnchecked(Exception e) {
        if (e instanceof IllegalAccessException || e instanceof IllegalArgumentException || e instanceof NoSuchMethodException) {
            return new IllegalArgumentException("Reflection Exception.", e);
        }
        if (e instanceof InvocationTargetException) {
            return new RuntimeException("Reflection Exception.", ((InvocationTargetException)e).getTargetException());
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException("Unexpected Checked Exception.", e);
    }

    public static void setObjectFieldsEmpty(Object obj) {
        int i;
        Class<?> objClass = obj.getClass();
        Method[] objmethods = objClass.getDeclaredMethods();
        HashMap<String, Method> objMeMap = new HashMap<String, Method>();
        for (i = 0; i < objmethods.length; ++i) {
            Method method = objmethods[i];
            objMeMap.put(method.getName(), method);
        }
        for (i = 0; i < objmethods.length; ++i) {
            String methodName = objmethods[i].getName();
            if (methodName == null || !methodName.startsWith("get")) continue;
            try {
                Object returnObj = objmethods[i].invoke(obj, new Object[0]);
                Method setmethod = (Method)objMeMap.get("set" + methodName.split("get")[1]);
                if (returnObj != null) {
                    returnObj = null;
                }
                setmethod.invoke(obj, returnObj);
                continue;
            }
            catch (IllegalArgumentException e) {
                logger.error("setObjectFieldsEmpty error", (Throwable)e);
                continue;
            }
            catch (IllegalAccessException e) {
                logger.error("setObjectFieldsEmpty error", (Throwable)e);
                continue;
            }
            catch (InvocationTargetException e) {
                logger.error("setObjectFieldsEmpty error", (Throwable)e);
            }
        }
    }
}

