/*
 * Decompiled with CFR 0.152.
 */
package cn.wwwlike.vlife.query;

import cn.wwwlike.vlife.base.BaseRequest;
import cn.wwwlike.vlife.base.Item;
import cn.wwwlike.vlife.base.OrderRequest;
import cn.wwwlike.vlife.dict.Opt;
import cn.wwwlike.vlife.objship.dto.FieldDto;
import cn.wwwlike.vlife.objship.dto.ReqDto;
import cn.wwwlike.vlife.objship.read.GlobalData;
import cn.wwwlike.vlife.query.AbstractWrapper;
import cn.wwwlike.vlife.query.DataExpressTran;
import cn.wwwlike.vlife.utils.ReflectionUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.data.domain.Sort;

public abstract class CustomQuery<T extends Item, Q extends AbstractWrapper>
implements BaseRequest<T> {
    @JsonIgnore
    protected Class<T> entityClz;
    @JsonIgnore
    protected OrderRequest order = new OrderRequest();
    @JsonIgnore
    private Q queryWrapper;

    public Q getQueryWrapper() {
        if (this.queryWrapper == null) {
            this.qw();
        }
        return this.queryWrapper;
    }

    public abstract Q instance();

    public Q qw(Class<T> clz) {
        if (Item.class.isAssignableFrom(clz)) {
            // empty if block
        }
        this.entityClz = clz;
        if (this.queryWrapper == null) {
            this.queryWrapper = this.getJoinQueryWrapper(GlobalData.reqDto(this.getClass()));
        }
        return this.queryWrapper;
    }

    public Q qw() {
        if (this.queryWrapper != null) {
            return this.queryWrapper;
        }
        return this.qw(this.entityClz != null && Item.class.isAssignableFrom(this.entityClz) ? this.entityClz : this.getEntity());
    }

    protected Q getJoinQueryWrapper(ReqDto reqDto) {
        Object wrapper = null;
        if (reqDto != null && reqDto.getFields() != null) {
            List<FieldDto> fields = reqDto.getFields();
            for (FieldDto fieldDto : fields) {
                if (ReflectionUtils.getFieldValue(this, fieldDto.getFieldName()) == null || fieldDto.getVField() != null && fieldDto.getVField().skip()) continue;
                Object val = ReflectionUtils.getFieldValue(this, fieldDto.getFieldName());
                wrapper = this.createWrapperFromQueryPath(wrapper, fieldDto, val);
            }
        }
        if (wrapper == null) {
            wrapper = this.instance();
        }
        return wrapper;
    }

    private Q createWrapperFromQueryPath(Q qw, FieldDto fieldDto, Object val) {
        if (fieldDto.getVField() != null && fieldDto.getVField().orReqFields().length > 0) {
            List list = Arrays.stream(fieldDto.getVField().orReqFields()).collect(Collectors.toList());
            list.add(fieldDto.getEntityFieldName());
            if (qw == null) {
                qw = this.instance();
            }
            qw.or(ww -> this.createWrapperFromQueryPath((AbstractWrapper)ww, fieldDto.getQueryPath(), val, fieldDto.getOpt(), fieldDto.getTran(), list.toArray(new String[list.size()])));
            return qw;
        }
        return this.createWrapperFromQueryPath(qw, fieldDto.getQueryPath(), val, fieldDto.getOpt(), fieldDto.getTran(), fieldDto.getEntityFieldName());
    }

    private Q createWrapperFromQueryPath(Q qw, List queryPath, Object val, Opt opt, DataExpressTran tran, String ... lastQueryPathFieldName) {
        ArrayList<Class> leftClz = new ArrayList<Class>();
        for (Object o : queryPath) {
            if (qw == null) {
                qw = this.instance();
            }
            if (o instanceof List) {
                Consumer<AbstractWrapper> subQuery = abc -> this.createWrapperFromQueryPath(abc, (List)o, val, opt, tran, lastQueryPathFieldName);
                qw.andSub((Class)((List)o).get(0), subQuery, leftClz.toArray(new Class[leftClz.size()]));
                continue;
            }
            leftClz.add((Class)o);
        }
        Class[] leftArray = leftClz.toArray(new Class[leftClz.size()]);
        for (String reqName : lastQueryPathFieldName) {
            if (!(queryPath.get(queryPath.size() - 1) instanceof Class)) continue;
            if (opt == Opt.in || opt == Opt.notIn) {
                ((AbstractWrapper)qw).in(true, reqName, val instanceof List ? ((List)val).toArray() : (Object[])val, tran, leftArray);
                continue;
            }
            if (opt == Opt.between || opt == Opt.notBetween) {
                ((AbstractWrapper)qw).between(true, (Object)reqName, ((List)val).get(0), ((List)val).get(1), tran, leftArray);
                continue;
            }
            if (opt == Opt.eq || opt == Opt.ne) {
                ((AbstractWrapper)qw).eq(true, (Object)reqName, val, tran, leftArray);
                continue;
            }
            if (opt == Opt.like || opt == Opt.notLike) {
                ((AbstractWrapper)qw).like(true, (Object)reqName, (Object)("%" + val + "%"), tran, leftArray);
                continue;
            }
            if (opt == Opt.isNotNull || opt == Opt.isNull) {
                ((AbstractWrapper)qw).isNotNull((boolean)((Boolean)val), reqName, leftArray);
                continue;
            }
            if (opt != Opt.startsWith && opt != Opt.endsWith && opt != Opt.gt && opt != Opt.goe && opt != Opt.lt && opt != Opt.loe) continue;
            ((AbstractWrapper)qw).startsWith(true, (Object)reqName, val, tran, leftArray);
        }
        return qw;
    }

    public CustomQuery addOrder(String ... field) {
        for (String f : field) {
            if (this.getOrder() == null) {
                this.order = new OrderRequest(f, Sort.Direction.ASC);
                continue;
            }
            this.getOrder().addOrder(f, Sort.Direction.ASC);
        }
        return this;
    }

    public CustomQuery addDescOrder(String ... field) {
        for (String f : field) {
            if (this.getOrder() == null) {
                this.order = new OrderRequest(f, Sort.Direction.DESC);
                continue;
            }
            this.getOrder().addOrder(f, Sort.Direction.DESC);
        }
        return this;
    }

    public Class<T> getEntityClz() {
        return this.entityClz;
    }

    @Override
    public OrderRequest getOrder() {
        return this.order;
    }

    @JsonIgnore
    public void setEntityClz(Class<T> entityClz) {
        this.entityClz = entityClz;
    }

    @JsonIgnore
    public void setOrder(OrderRequest order) {
        this.order = order;
    }

    @JsonIgnore
    public void setQueryWrapper(Q queryWrapper) {
        this.queryWrapper = queryWrapper;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomQuery)) {
            return false;
        }
        CustomQuery other = (CustomQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<T> this$entityClz = this.getEntityClz();
        Class<T> other$entityClz = other.getEntityClz();
        if (this$entityClz == null ? other$entityClz != null : !this$entityClz.equals(other$entityClz)) {
            return false;
        }
        OrderRequest this$order = this.getOrder();
        OrderRequest other$order = other.getOrder();
        if (this$order == null ? other$order != null : !((Object)this$order).equals(other$order)) {
            return false;
        }
        Q this$queryWrapper = this.getQueryWrapper();
        Q other$queryWrapper = other.getQueryWrapper();
        return !(this$queryWrapper == null ? other$queryWrapper != null : !this$queryWrapper.equals(other$queryWrapper));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CustomQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<T> $entityClz = this.getEntityClz();
        result = result * 59 + ($entityClz == null ? 43 : $entityClz.hashCode());
        OrderRequest $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
        Q $queryWrapper = this.getQueryWrapper();
        result = result * 59 + ($queryWrapper == null ? 43 : $queryWrapper.hashCode());
        return result;
    }

    public String toString() {
        return "CustomQuery(entityClz=" + this.getEntityClz() + ", order=" + this.getOrder() + ", queryWrapper=" + this.getQueryWrapper() + ")";
    }
}

