/*
 * Decompiled with CFR 0.152.
 */
package cn.wwwlike.vlife.objship.read;

import cn.wwwlike.base.model.IdBean;
import cn.wwwlike.vlife.annotation.VClazz;
import cn.wwwlike.vlife.base.Item;
import cn.wwwlike.vlife.base.SaveBean;
import cn.wwwlike.vlife.base.VoBean;
import cn.wwwlike.vlife.objship.base.FieldInfo;
import cn.wwwlike.vlife.objship.dto.EntityDto;
import cn.wwwlike.vlife.objship.dto.FieldDto;
import cn.wwwlike.vlife.objship.dto.VoDto;
import cn.wwwlike.vlife.objship.read.GlobalData;
import cn.wwwlike.vlife.objship.read.ItemReadTemplate;
import cn.wwwlike.vlife.utils.GenericsUtils;
import java.util.List;
import java.util.stream.Collectors;

public class VoRead
extends ItemReadTemplate<VoDto> {
    private static VoRead INSTANCE = null;

    private VoRead(List<EntityDto> info) {
        infos = info;
    }

    public static VoRead getInstance(List<EntityDto> info) {
        if (INSTANCE == null) {
            INSTANCE = new VoRead(info);
        }
        return INSTANCE;
    }

    @Override
    public VoDto readInfo(Class s) {
        VoDto dto = null;
        if (VoBean.class.isAssignableFrom(s) && s != VoBean.class && s != SaveBean.class) {
            dto = new VoDto();
            this.superRead(dto, s);
            dto.setItemType("vo");
            Class entityClz = GenericsUtils.getGenericType(s);
            if (entityClz == null || !Item.class.isAssignableFrom(entityClz)) {
                dto.setState("-1");
            } else {
                dto.setEntityClz(entityClz);
                dto.setEntityType(entityClz.getSimpleName());
            }
            dto.setOrders("createDate_desc");
            VClazz f = s.getAnnotation(VClazz.class);
            if (f != null && f.orders() != null) {
                dto.setOrders(f.orders());
            }
        }
        return dto;
    }

    @Override
    public void relation() {
        for (VoDto item : this.readAll) {
            EntityDto entityDto = GlobalData.entityDto(item.getEntityClz());
            item.setEntityDto(entityDto);
            List<FieldDto> fkFields = entityDto.getFkFields();
            List<Class<? extends Item>> in = entityDto.getFkTableClz();
            for (FieldDto fieldDto2 : item.getFields()) {
                if (fieldDto2.getEntityFieldName() == null) {
                    if ("basic".equals(fieldDto2.getFieldType()) || !IdBean.class.isAssignableFrom(fieldDto2.getClz())) {
                        List queryPath = this.basicFieldMatch(item, fieldDto2);
                        if (queryPath != null) {
                            fieldDto2.setQueryPath(queryPath);
                        }
                    } else {
                        this.iocReverseMatch(fieldDto2, entityDto);
                    }
                }
                this.syncDictCode(fieldDto2);
            }
            List loseStr = fkFields.stream().filter(fieldDto -> item.getFields().stream().filter(voField -> fieldDto.getFieldName().equals(voField.getEntityFieldName())).count() == 0L).map(FieldInfo::getFieldName).collect(Collectors.toList());
            for (int i = 0; i < loseStr.size(); ++i) {
                item.getLoseIds().put((String)loseStr.get(i), i);
            }
        }
        ItemReadTemplate.voDtos = this.readAll;
    }
}

