/*
 * Decompiled with CFR 0.152.
 */
package cn.wwwlike.vlife.objship.read;

import cn.wwwlike.base.model.IdBean;
import cn.wwwlike.vlife.base.Item;
import cn.wwwlike.vlife.base.SaveBean;
import cn.wwwlike.vlife.objship.dto.EntityDto;
import cn.wwwlike.vlife.objship.dto.FieldDto;
import cn.wwwlike.vlife.objship.dto.SaveDto;
import cn.wwwlike.vlife.objship.read.GlobalData;
import cn.wwwlike.vlife.objship.read.ItemReadTemplate;
import cn.wwwlike.vlife.utils.GenericsUtils;
import java.util.List;

public class SaveRead
extends ItemReadTemplate<SaveDto> {
    private static SaveRead INSTANCE = null;

    private SaveRead(List<EntityDto> info) {
        infos = info;
    }

    public static SaveRead getInstance(List<EntityDto> info) {
        if (INSTANCE == null) {
            INSTANCE = new SaveRead(info);
        }
        return INSTANCE;
    }

    @Override
    public SaveDto readInfo(Class s) {
        SaveDto dto = null;
        if (SaveBean.class.isAssignableFrom(s) && s != SaveBean.class) {
            dto = new SaveDto();
            this.superRead(dto, s);
            dto.setItemType("save");
            Class entityClz = GenericsUtils.getGenericType(s);
            if (entityClz == null || !Item.class.isAssignableFrom(entityClz)) {
                dto.setState("-1");
            } else {
                dto.setEntityClz(entityClz);
                dto.setEntityType(entityClz.getSimpleName());
            }
        }
        return dto;
    }

    @Override
    public void relation() {
        for (SaveDto item : this.readAll) {
            EntityDto entityDto = GlobalData.entityDto(item.getEntityClz());
            item.setEntityDto(entityDto);
            List<FieldDto> fkFields = entityDto.getFkFields();
            List<Class<? extends Item>> in = entityDto.getFkTableClz();
            for (FieldDto fieldDto : item.getFields()) {
                if (fieldDto.getEntityFieldName() == null && !"basic".equals(fieldDto.getFieldType())) {
                    if (!IdBean.class.isAssignableFrom(fieldDto.getClz())) {
                        List queryPath = this.basicFieldMatch(item, fieldDto);
                        if (queryPath != null) {
                            fieldDto.setQueryPath(queryPath);
                        }
                    } else {
                        this.iocReverseMatch(fieldDto, entityDto);
                    }
                }
                this.syncDictCode(fieldDto);
            }
        }
        ItemReadTemplate.saveDtos = this.readAll;
    }
}

