/*
 * Decompiled with CFR 0.152.
 */
package cn.wwwlike.vlife.objship.read;

import cn.wwwlike.base.model.IdBean;
import cn.wwwlike.vlife.base.BaseRequest;
import cn.wwwlike.vlife.base.Item;
import cn.wwwlike.vlife.objship.dto.EntityDto;
import cn.wwwlike.vlife.objship.dto.FieldDto;
import cn.wwwlike.vlife.objship.dto.ReqDto;
import cn.wwwlike.vlife.objship.read.GlobalData;
import cn.wwwlike.vlife.objship.read.ItemReadTemplate;
import cn.wwwlike.vlife.utils.GenericsUtils;
import java.util.List;

public class ReqRead
extends ItemReadTemplate<ReqDto> {
    private static ReqRead INSTANCE = null;

    private ReqRead(List<EntityDto> info) {
        infos = info;
    }

    public static ReqRead getInstance(List<EntityDto> info) {
        if (INSTANCE == null) {
            INSTANCE = new ReqRead(info);
        }
        return INSTANCE;
    }

    @Override
    public ReqDto readInfo(Class s) {
        ReqDto dto = null;
        if (BaseRequest.class.isAssignableFrom(s) && s != BaseRequest.class) {
            dto = new ReqDto();
            this.superRead(dto, s);
            dto.setItemType("req");
            Class entityClz = GenericsUtils.getGenericType(s);
            if (entityClz == null || !Item.class.isAssignableFrom(entityClz)) {
                dto.setState("-1");
            } else {
                dto.setEntityClz(entityClz);
                dto.setEntityType(entityClz.getSimpleName());
            }
        }
        return dto;
    }

    @Override
    public void relation() {
        for (ReqDto item : this.readAll) {
            EntityDto entityDto = GlobalData.entityDto(item.getEntityClz());
            item.setEntityDto(entityDto);
            if (item.getFields() == null) continue;
            for (FieldDto fieldDto : item.getFields()) {
                if (fieldDto.getEntityFieldName() == null && ("basic".equals(fieldDto.getFieldType()) || !IdBean.class.isAssignableFrom(fieldDto.getClz()))) {
                    fieldDto.setQueryPath(this.basicFieldMatch(item, fieldDto));
                }
                this.syncDictCode(fieldDto);
            }
        }
        ItemReadTemplate.reqDtos = this.readAll;
    }
}

