/*
 * Decompiled with CFR 0.152.
 */
package cn.wwwlike.vlife.objship.read;

import cn.wwwlike.vlife.objship.base.FieldInfo;
import cn.wwwlike.vlife.objship.base.ItemInfo;
import cn.wwwlike.vlife.objship.dto.BeanDto;
import cn.wwwlike.vlife.objship.dto.EntityDto;
import cn.wwwlike.vlife.objship.dto.FieldDto;
import cn.wwwlike.vlife.objship.dto.NotEntityDto;
import cn.wwwlike.vlife.objship.dto.ReqDto;
import cn.wwwlike.vlife.objship.dto.SaveDto;
import cn.wwwlike.vlife.objship.dto.VoDto;
import cn.wwwlike.vlife.objship.read.EntityRead;
import cn.wwwlike.vlife.objship.read.GlobalData;
import cn.wwwlike.vlife.objship.read.ItemReadTemplate;
import cn.wwwlike.vlife.objship.read.ReqRead;
import cn.wwwlike.vlife.objship.read.SaveRead;
import cn.wwwlike.vlife.objship.read.VoRead;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class ModelReadCheck {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<EntityDto> itemDtos = null;
    private List<VoDto> voDtos = null;
    private List<ReqDto> reqDtos = null;
    private List<SaveDto> saveDtos = null;

    public BeanDto find(String beanName) {
        Optional<BeanDto> obj;
        if (this.itemDtos != null && (obj = this.itemDtos.stream().filter(t -> t.getType().equals(beanName)).findFirst()).isPresent()) {
            return obj.get();
        }
        if (this.voDtos != null && (obj = this.voDtos.stream().filter(t -> t.getType().equals(beanName)).findFirst()).isPresent()) {
            return obj.get();
        }
        if (this.reqDtos != null && (obj = this.reqDtos.stream().filter(t -> t.getType().equals(beanName)).findFirst()).isPresent()) {
            return obj.get();
        }
        if (this.saveDtos != null && (obj = this.saveDtos.stream().filter(t -> t.getType().equals(beanName)).findFirst()).isPresent()) {
            return obj.get();
        }
        return null;
    }

    public Integer load(ClassLoader loader) {
        return this.load(loader, "");
    }

    public Integer load(ClassLoader loader, String path) {
        List<String> list = ItemReadTemplate.readPackage(loader, path);
        this.logger.info("\u8bfb\u53d6Java\u7c7b\u6570\u91cf\uff1a" + list.size());
        Integer errorNum = 0;
        try {
            GlobalData.clear();
            EntityRead read = EntityRead.getInstance();
            this.itemDtos = read.read(loader, list);
            GlobalData.save(this.itemDtos);
            VoRead voRead = VoRead.getInstance(this.itemDtos);
            this.voDtos = voRead.read(loader, list);
            GlobalData.save(this.voDtos);
            ReqRead reqRead = ReqRead.getInstance(this.itemDtos);
            this.reqDtos = reqRead.read(loader, list);
            GlobalData.save(this.reqDtos);
            SaveRead saveRead = SaveRead.getInstance(this.itemDtos);
            this.saveDtos = saveRead.read(loader, list);
            GlobalData.save(this.saveDtos);
            errorNum = this.errInfo(this.itemDtos, this.voDtos, this.reqDtos, this.saveDtos);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return errorNum;
    }

    public boolean checkField(BeanDto table, FieldDto fieldDto) {
        Boolean checkFailed = false;
        String tableName = table.getClass().getSimpleName();
        if (fieldDto.getFieldType() == null || fieldDto.getEntityClz() == null) {
            this.logger.error("[" + tableName + "]" + ((BeanDto)fieldDto.getItemDto()).getClz().getSimpleName() + "\u6a21\u578b\u7684[" + fieldDto.getFieldName() + "<" + fieldDto.getClz().getSimpleName() + ">]\u65e0\u6cd5\u5339\u914d");
            return checkFailed;
        }
        if (fieldDto.getFieldType().equals("basic")) {
            if (fieldDto.getEntityFieldName() == null || fieldDto.getQueryPath() == null) {
                this.logger.error("[" + tableName + "]" + ((BeanDto)fieldDto.getItemDto()).getClz().getSimpleName() + "\u7684" + fieldDto.getFieldName() + "\u5b57\u6bb5\u6ca1\u6709\u627e\u5230\u5339\u914d\u7684\u5b9e\u4f53\u5b57\u6bb5");
                return checkFailed;
            }
            if (table instanceof VoDto || table instanceof SaveDto) {
                for (Object path : fieldDto.getQueryPath()) {
                    if (!(path instanceof List)) continue;
                    this.logger.error("[" + tableName + "]" + ((BeanDto)fieldDto.getItemDto()).getClz().getSimpleName() + "\u6a21\u578b\u7684[" + fieldDto.getFieldName() + "]\u7c7b\u578b\u5e94\u8be5\u4e3a\u96c6\u5408List<" + fieldDto.getClz().getSimpleName() + ">");
                    return checkFailed;
                }
            }
        } else {
            if (fieldDto.getQueryPath() == null || fieldDto.queryPathName() == null) {
                this.logger.error("[" + tableName + "]" + ((BeanDto)fieldDto.getItemDto()).getClz().getSimpleName() + "\u6a21\u578b\u7684" + fieldDto.getFieldName() + "\u67e5\u8be2\u8def\u5f84\u6ca1\u6709\u627e\u5230\uff0c\u8bf7\u68c0\u67e5\u5b57\u6bb5\u540d\u79f0\u3001\u5b57\u6bb5\u7c7b\u578b\u662f\u5426\u51c6\u786e");
                return checkFailed;
            }
            if (table instanceof VoDto || table instanceof SaveDto) {
                if (fieldDto.getFieldType().equals("list") && !this.iocFieldSholudList(fieldDto.getQueryPath())) {
                    this.logger.error("[" + tableName + "]" + ((BeanDto)fieldDto.getItemDto()).getClz().getSimpleName() + "\u6a21\u578b\u7684[" + fieldDto.getFieldName() + "]\u4e0d\u5e94\u8be5\u662fList<" + fieldDto.getClz().getSimpleName() + ">");
                    return checkFailed;
                }
                if (!fieldDto.getFieldType().equals("list") && this.iocFieldSholudList(fieldDto.getQueryPath())) {
                    this.logger.error("[" + tableName + "]" + ((BeanDto)fieldDto.getItemDto()).getClz().getSimpleName() + "\u6a21\u578b\u7684[" + fieldDto.getFieldName() + "]\u5e94\u8be5\u662fList<" + fieldDto.getClz().getSimpleName() + ">");
                    return checkFailed;
                }
            }
        }
        return true;
    }

    private boolean iocFieldSholudList(List queryPath) {
        Object lastType = queryPath.get(queryPath.size() - 1);
        if (queryPath.size() >= 3 || !(lastType instanceof List)) {
            return true;
        }
        if (queryPath.size() == 2 && ((List)lastType).size() > 1) {
            return this.iocFieldSholudList((List)lastType);
        }
        return ((List)lastType).size() != 1;
    }

    public Integer errInfo(List<? extends BeanDto> ... beanDtos) {
        Integer errorNum = 0;
        for (List<? extends BeanDto> list : beanDtos) {
            for (BeanDto beanDto : list) {
                List<FieldDto> fieldDtos;
                if (beanDto instanceof NotEntityDto && ((NotEntityDto)((Object)beanDto)).getEntityClz() == null) {
                    errorNum = errorNum + 1;
                    this.logger.error("[model] " + beanDto.getType() + " require write <Item>");
                }
                if ((fieldDtos = beanDto.getFields()) != null) {
                    for (FieldDto fieldDto : fieldDtos) {
                        if (fieldDto.getVField() != null && fieldDto.getVField().skip()) continue;
                        errorNum = !this.checkField(beanDto, fieldDto) ? errorNum + 1 : errorNum;
                    }
                }
                if (!(beanDto instanceof VoDto)) continue;
            }
        }
        return errorNum;
    }

    public void save(List<? extends BeanDto> ... beanDtos) {
        for (List<? extends BeanDto> list : beanDtos) {
            for (BeanDto beanDto : list) {
                ItemInfo info = new ItemInfo();
                BeanUtils.copyProperties((Object)beanDto, (Object)info);
                List<FieldDto> fieldDtos = beanDto.getFields();
                for (FieldDto fieldDto : fieldDtos) {
                    FieldInfo fieldInfo = new FieldInfo();
                    BeanUtils.copyProperties((Object)fieldDto, (Object)fieldInfo);
                }
            }
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public List<EntityDto> getItemDtos() {
        return this.itemDtos;
    }

    public List<VoDto> getVoDtos() {
        return this.voDtos;
    }

    public List<ReqDto> getReqDtos() {
        return this.reqDtos;
    }

    public List<SaveDto> getSaveDtos() {
        return this.saveDtos;
    }
}

