/*
 * Decompiled with CFR 0.152.
 */
package cn.wwwlike.vlife.objship.read;

import cn.wwwlike.base.model.IdBean;
import cn.wwwlike.vlife.base.Item;
import cn.wwwlike.vlife.base.SaveBean;
import cn.wwwlike.vlife.base.VoBean;
import cn.wwwlike.vlife.objship.base.ClazzInfo;
import cn.wwwlike.vlife.objship.dto.BeanDto;
import cn.wwwlike.vlife.objship.dto.EntityDto;
import cn.wwwlike.vlife.objship.dto.FieldDto;
import cn.wwwlike.vlife.objship.dto.NotEntityDto;
import cn.wwwlike.vlife.objship.dto.ReqDto;
import cn.wwwlike.vlife.objship.dto.ReqVoDto;
import cn.wwwlike.vlife.objship.dto.SaveDto;
import cn.wwwlike.vlife.objship.dto.VoDto;
import cn.wwwlike.vlife.objship.read.ClazzRead;
import cn.wwwlike.vlife.objship.read.FieldRead;
import cn.wwwlike.vlife.objship.read.GlobalData;
import cn.wwwlike.vlife.objship.read.tag.ClzTag;
import cn.wwwlike.vlife.utils.FileUtil;
import cn.wwwlike.vlife.utils.GenericsUtils;
import cn.wwwlike.vlife.utils.PackageUtil;
import cn.wwwlike.vlife.utils.VlifeUtils;
import com.google.common.reflect.TypeToken;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.ResourceUtils;

public abstract class ItemReadTemplate<T extends BeanDto>
implements ClazzRead<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static List<ClzTag> clzTags = null;
    protected static List<EntityDto> infos = null;
    protected static List<VoDto> voDtos = null;
    protected static List<ReqDto> reqDtos = null;
    protected static List<SaveDto> saveDtos = null;
    protected List<T> readAll;
    protected List<FieldDto> fieldDtoList = null;
    private List<String> ignores = Arrays.asList("groupBys");
    public static final Gson GSON = new GsonBuilder().addDeserializationExclusionStrategy(new ExclusionStrategy(){

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return false;
        }

        public boolean shouldSkipClass(Class aClass) {
            return false;
        }
    }).create();

    public void readTitleJson(String model) {
        try {
            String json = null;
            ClassPathResource resource = new ClassPathResource("title.json");
            if (resource.isFile()) {
                InputStream is = resource.getInputStream();
                json = FileUtil.getFileContent(is);
            } else {
                File jsonFile = ResourceUtils.getFile((String)"./src/main/resources/title.json");
                if (jsonFile.isFile()) {
                    json = FileUtils.readFileToString((File)jsonFile, (String)"UTF-8");
                } else {
                    InputStream is = ClassPathResource.class.getClassLoader().getResourceAsStream("/title.json");
                    if (is != null) {
                        json = FileUtil.getFileContent(is);
                    }
                }
            }
            if (json != null) {
                clzTags = (List)GSON.fromJson(json, new TypeToken<List<ClzTag>>(){}.getType());
            } else {
                this.logger.warn("no comments,because not created title.json with vlife-plugin");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static String getClzType(Class clz) {
        if (clz.isArray()) {
            return "list";
        }
        if (BeanUtils.isSimpleProperty((Class)clz)) {
            return "basic";
        }
        if (Collection.class.isAssignableFrom(clz)) {
            return "list";
        }
        if (Item.class.isAssignableFrom(clz)) {
            return "entity";
        }
        if (VoBean.class.isAssignableFrom(clz)) {
            return "vo";
        }
        if (SaveBean.class.isAssignableFrom(clz)) {
            return "save";
        }
        if (ReqDto.class.isAssignableFrom(clz)) {
            return "req";
        }
        return "api";
    }

    public static List<String> readPackage(String ... packageNames) {
        ArrayList<String> classStr = new ArrayList<String>();
        for (String packageName : packageNames) {
            List<String> classNames = PackageUtil.getClassName(packageName, true);
            if (classNames == null) continue;
            classStr.addAll(classNames);
        }
        return classStr;
    }

    public static List<String> readPackage(ClassLoader classLoader, String ... packageNames) {
        ArrayList<String> classStr = new ArrayList<String>();
        for (String packageName : packageNames) {
            List<String> classNames = PackageUtil.getClassName(classLoader, packageName, true);
            if (classNames == null) continue;
            classStr.addAll(classNames);
        }
        return classStr.stream().filter(classFullName -> classFullName.indexOf(".entity.") != -1 || classFullName.indexOf(".req.") != -1 || classFullName.indexOf(".vo.") != -1 || classFullName.indexOf(".item.") != -1 || classFullName.indexOf(".do.") != -1 || classFullName.indexOf(".dto.") != -1).collect(Collectors.toList());
    }

    protected T superRead(T dto, Class s) {
        ((ClazzInfo)dto).setType(StringUtils.uncapitalize((String)s.getSimpleName()));
        ((BeanDto)dto).setClz(s);
        return dto;
    }

    public List<T> read(ClassLoader loader, List<String> clazzPackageUrl) throws ClassNotFoundException {
        this.readAll = new ArrayList<T>();
        for (String url : clazzPackageUrl) {
            Class<?> clazz = null;
            try {
                if (url.startsWith("BOOT-INF.classes.")) {
                    url = url.substring(17);
                }
                this.logger.info("url:" + url);
                clazz = loader.loadClass(url);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            Object dto = this.readInfo(clazz);
            if (dto == null) continue;
            if (!"-1".equals(((ClazzInfo)dto).getState())) {
                Field[] fields;
                this.fieldDtoList = new ArrayList<FieldDto>();
                for (Field field : fields = Item.class.isAssignableFrom(clazz) ? clazz.getFields() : clazz.getDeclaredFields()) {
                    if (this.ignores.contains(field.getName())) continue;
                    FieldDto fieldDto = FieldRead.getInstance().read(field, dto);
                    if ("-1".equals(fieldDto.getState())) {
                        ((ClazzInfo)dto).setState("-1");
                    }
                    this.fieldDtoList.add(fieldDto);
                }
                ((BeanDto)dto).setFields(this.fieldDtoList);
            }
            this.readAll.add(dto);
        }
        this.relation();
        for (BeanDto beanInfo : this.readAll) {
            this.commentRead(beanInfo);
            if (!(beanInfo instanceof NotEntityDto)) continue;
            this.commentPerfect(beanInfo);
        }
        return this.readAll;
    }

    private T commentPerfect(T beanInfo) {
        if (StringUtils.isEmpty((CharSequence)((ClazzInfo)beanInfo).getTitle())) {
            ((ClazzInfo)beanInfo).setTitle(((NotEntityDto)beanInfo).getEntityDto().getTitle() + "(\u89c6\u56fe)");
        }
        List<FieldDto> fieldDtos = ((BeanDto)beanInfo).getFields();
        fieldDtos.stream().forEach(modelField -> infos.stream().forEach(entityDto -> {
            if (modelField.getEntityClz() != null && entityDto.getClz() == modelField.getEntityClz()) {
                if (modelField.getEntityFieldName() != null) {
                    Optional<FieldDto> optionalFieldDto = entityDto.getFields().stream().filter(ff -> ff.getFieldName().equals(modelField.getEntityFieldName()) && ff.getItemClz() == modelField.getEntityClz()).findFirst();
                    if (optionalFieldDto.isPresent() && (modelField.getTitle() == null || modelField.getTitle().equals(modelField.getFieldName()))) {
                        modelField.setTitle(optionalFieldDto.get().getTitle());
                    }
                } else if (modelField.getTitle() == null) {
                    modelField.setTitle(entityDto.getTitle());
                }
            }
        }));
        return beanInfo;
    }

    @Override
    public T commentRead(T beanInfo) {
        Optional<ClzTag> optional;
        if (clzTags != null && (optional = clzTags.stream().filter(tag -> tag.getEntityName() != null && tag.getEntityName().equalsIgnoreCase(beanInfo.getType())).findFirst()).isPresent()) {
            ClzTag tag2 = optional.get();
            if (tag2.getTitle() != null) {
                ((ClazzInfo)beanInfo).setTitle(tag2.getTitle());
            }
            if (tag2.getTags().size() > 0) {
                List<FieldDto> fieldDtos = ((BeanDto)beanInfo).getFields();
                fieldDtos.stream().forEach(field -> {
                    if (tag2.getTags().get(field.getFieldName()) != null) {
                        field.setTitle(tag2.getTags().get(field.getFieldName()).getTitle());
                    }
                });
            }
        }
        return beanInfo;
    }

    public Class<? extends Item>[] pathClz(String ... path) {
        Class[] clz = new Class[path.length - 1];
        for (int i = 0; i < clz.length; ++i) {
            clz[i] = GlobalData.entityDto(path[i]).getClz();
        }
        return clz;
    }

    public Field matchField(EntityDto root, String fieldName) {
        String[] fullPath = fieldName.split("_");
        if (fieldName.indexOf("_") != -1) {
            return this.matchFieldByLeftPath(root, fullPath);
        }
        return FieldRead.match(root.getClz(), fieldName);
    }

    protected Field matchFieldByLeftPath(Class<? extends Item> root, String ... path) {
        return this.matchFieldByLeftPath(GlobalData.entityDto(root), path);
    }

    protected Field matchFieldByLeftPath(EntityDto root, String ... path) {
        List<Class<? extends Item>> clzs = root.getFkTableClz();
        String first = path[0];
        BeanDto next = null;
        for (Class<? extends Item> clz : clzs) {
            if (!clz.getSimpleName().equalsIgnoreCase(first)) continue;
            next = GlobalData.entityDto(clz);
            break;
        }
        if (next != null) {
            if (path.length == 2) {
                return FieldRead.match(next.getClz(), path[1]);
            }
            return this.matchFieldByLeftPath((EntityDto)next, Arrays.copyOfRange(path, 1, path.length));
        }
        return null;
    }

    protected <T extends NotEntityDto> List basicFieldMatch(T item, FieldDto fieldDto) {
        EntityDto entityDto = GlobalData.entityDto(item.getEntityClz());
        List<Class<? extends Item>> lefts = entityDto.getFkTableClz();
        List<Class<? extends Item>> rights = entityDto.getRelationTableClz();
        Field matchf = null;
        String voFieldName = fieldDto.getPathName();
        int has_index = voFieldName.indexOf("_");
        if (has_index == -1) {
            for (Class<? extends Item> inItemClz : lefts) {
                matchf = FieldRead.match(inItemClz, voFieldName);
                if (matchf == null) continue;
                fieldDto.setEntityClz(inItemClz);
                fieldDto.setEntityType(inItemClz.getSimpleName());
                fieldDto.setEntityFieldName(matchf.getName());
                fieldDto.setState("1");
                return Arrays.asList(entityDto.getClz(), inItemClz);
            }
            for (Class<? extends Item> outItemClz : rights) {
                matchf = FieldRead.match(outItemClz, voFieldName);
                if (matchf == null) continue;
                fieldDto.setEntityClz(outItemClz);
                fieldDto.setEntityType(outItemClz.getSimpleName());
                fieldDto.setEntityFieldName(matchf.getName());
                fieldDto.setState("1");
                return Arrays.asList(entityDto.getClz(), Arrays.asList(outItemClz));
            }
        } else {
            String[] path = voFieldName.split("_");
            Boolean leftToRight = item instanceof ReqDto ? true : "basic".equals(fieldDto.getFieldType());
            Class<Item> itemClz = this._MatchAndSetEntityPath(fieldDto, leftToRight);
            if (itemClz != null) {
                matchf = FieldRead.match(itemClz, path[path.length - 1]);
            }
            if (matchf != null) {
                fieldDto.setEntityClz(itemClz);
                fieldDto.setEntityFieldName(matchf.getName());
                fieldDto.setEntityType(itemClz.getSimpleName());
                fieldDto.setState("1");
                return fieldDto.getQueryPath();
            }
        }
        if (fieldDto.getEntityFieldName() == null) {
            fieldDto.setState("-1");
        }
        return null;
    }

    protected <T extends ReqVoDto> FieldDto iocReverseMatch(FieldDto fieldDto, EntityDto voEntityDto) {
        Class entityClz;
        String fieldType = fieldDto.getFieldType();
        String voFieldName = fieldDto.getPathName();
        Class fieldClz = fieldDto.getClz();
        Class clazz = entityClz = Item.class.isAssignableFrom(fieldClz) ? fieldClz : GenericsUtils.getGenericType(fieldClz);
        if (voFieldName.indexOf("_") != -1) {
            Class<Item> pathNameLastElementEntityClz = this._MatchAndSetEntityPath(fieldDto, false);
            if (pathNameLastElementEntityClz != entityClz) {
                fieldDto.queryPath = null;
                return fieldDto;
            }
        } else if ("list".equals(fieldType) && voEntityDto.getRelationTableClz().contains(entityClz)) {
            fieldDto.setQueryPath(entityClz, voEntityDto.getClz());
        } else if (!"list".equals(fieldType) && voEntityDto.getFkMap().get(entityClz) != null) {
            ArrayList<Class> list = new ArrayList<Class>();
            list.add(entityClz);
            fieldDto.setQueryPath(entityClz, list);
        }
        if (entityClz != null) {
            fieldDto.setEntityClz(entityClz);
            fieldDto.setEntityType(StringUtils.uncapitalize((String)entityClz.getSimpleName()));
        }
        return fieldDto;
    }

    protected <T extends ReqVoDto> Class<? extends Item> _MatchAndSetEntityPath(FieldDto fieldDto, Boolean leftToRight) {
        List<String> entityNameList;
        List<Class> entityClzPaths;
        String voFieldName = fieldDto.getPathName();
        if (voFieldName.indexOf("_") == -1) {
            return null;
        }
        String[] _entityNames = voFieldName.split("_");
        String fieldType = fieldDto.getFieldType();
        if ("basic".equals(fieldType) || !IdBean.class.isAssignableFrom(fieldDto.getClz())) {
            _entityNames = Arrays.copyOfRange(_entityNames, 0, _entityNames.length - 1);
        }
        if (!leftToRight.booleanValue()) {
            _entityNames = VlifeUtils.reverseArray(_entityNames);
        }
        if ((entityClzPaths = (entityNameList = Arrays.asList(_entityNames)).stream().map(s -> {
            if (s.getClass() == String.class) {
                EntityDto entityDto = GlobalData.entityDto((String)s);
                if (entityDto != null) {
                    return entityDto.clz;
                }
                return null;
            }
            return s;
        }).collect(Collectors.toList())).contains(null)) {
            return null;
        }
        Class<? extends Item> itemEntityClz = ((NotEntityDto)fieldDto.getItemDto()).getEntityClz();
        if (leftToRight.booleanValue()) {
            entityClzPaths.add(0, itemEntityClz);
        } else {
            entityClzPaths.add(itemEntityClz);
        }
        List queryPath = this.createQueryPath(entityClzPaths);
        fieldDto.setQueryPath(queryPath);
        if (leftToRight.booleanValue()) {
            return entityClzPaths.get(entityClzPaths.size() - 1);
        }
        return entityClzPaths.get(0);
    }

    private List createQueryPath1(List<Class> entityClzPaths) {
        ArrayList<Class> list;
        boolean left = true;
        int subQuery = 2;
        Class before = null;
        ArrayList<Class> currList = list = new ArrayList<Class>();
        ArrayList<Class> sub = null;
        for (Class clz : entityClzPaths) {
            if (before == null) {
                list.add(clz);
            } else {
                int tablesRelation = this.checkTableFieldRelation(before, clz);
                if (tablesRelation == 1) {
                    if (sub == null) {
                        list.add(clz);
                    } else {
                        sub.add(clz);
                    }
                } else if (sub == null) {
                    sub = new ArrayList<Class>();
                    list.add(clz);
                } else {
                    sub.add(clz);
                }
            }
            before = clz;
        }
        return list;
    }

    private List createQueryPath(List<Class> entityClzPaths) {
        int left = 1;
        int right = 2;
        ArrayList<Serializable> list = new ArrayList<Serializable>();
        list.add(entityClzPaths.get(0));
        ArrayList<Serializable> curr = list;
        ArrayList<Class> sub = null;
        Class before = null;
        for (int i = 1; i < entityClzPaths.size(); ++i) {
            Class clz;
            int fx = this.checkTableFieldRelation(before == null ? entityClzPaths.get(0) : before, clz = entityClzPaths.get(i));
            if (fx == 0) {
                return null;
            }
            before = clz;
            if (left == fx && sub == null) {
                curr.add(clz);
                continue;
            }
            if (left == fx && sub != null) {
                sub.add(clz);
                continue;
            }
            if (right == fx && sub == null) {
                sub = new ArrayList<Class>();
                sub.add(clz);
                curr.add(sub);
                continue;
            }
            if (right != fx || sub == null) continue;
            curr = sub;
            sub = new ArrayList();
            sub.add(clz);
            curr.add(sub);
        }
        return list;
    }

    private int checkTableFieldRelation(Class<? extends Item> table, Class<? extends Item> table2) {
        EntityDto entityDto = GlobalData.entityDto(table);
        List<Class<? extends Item>> lefts = entityDto.getFkTableClz();
        List<Class<? extends Item>> rights = entityDto.getRelationTableClz();
        if (lefts.contains(table2)) {
            return 1;
        }
        if (rights.contains(table2)) {
            return 2;
        }
        return 0;
    }

    public void syncDictCode(FieldDto field) {
        if (field.getEntityFieldName() != null && field.getDictCode() == null) {
            infos.forEach(item -> {
                if (item.getClz() == field.getEntityClz()) {
                    item.getFields().forEach(f -> {
                        if (f.getFieldName().equals(field.getEntityFieldName()) && f.getDictCode() != null) {
                            field.setDictCode(f.getDictCode());
                        }
                    });
                }
            });
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public List<T> getReadAll() {
        return this.readAll;
    }

    public List<FieldDto> getFieldDtoList() {
        return this.fieldDtoList;
    }

    public List<String> getIgnores() {
        return this.ignores;
    }

    public void setReadAll(List<T> readAll) {
        this.readAll = readAll;
    }

    public void setFieldDtoList(List<FieldDto> fieldDtoList) {
        this.fieldDtoList = fieldDtoList;
    }

    public void setIgnores(List<String> ignores) {
        this.ignores = ignores;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemReadTemplate)) {
            return false;
        }
        ItemReadTemplate other = (ItemReadTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Logger this$logger = this.getLogger();
        Logger other$logger = other.getLogger();
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        List<T> this$readAll = this.getReadAll();
        List<T> other$readAll = other.getReadAll();
        if (this$readAll == null ? other$readAll != null : !((Object)this$readAll).equals(other$readAll)) {
            return false;
        }
        List<FieldDto> this$fieldDtoList = this.getFieldDtoList();
        List<FieldDto> other$fieldDtoList = other.getFieldDtoList();
        if (this$fieldDtoList == null ? other$fieldDtoList != null : !((Object)this$fieldDtoList).equals(other$fieldDtoList)) {
            return false;
        }
        List<String> this$ignores = this.getIgnores();
        List<String> other$ignores = other.getIgnores();
        return !(this$ignores == null ? other$ignores != null : !((Object)this$ignores).equals(other$ignores));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ItemReadTemplate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Logger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        List<T> $readAll = this.getReadAll();
        result = result * 59 + ($readAll == null ? 43 : ((Object)$readAll).hashCode());
        List<FieldDto> $fieldDtoList = this.getFieldDtoList();
        result = result * 59 + ($fieldDtoList == null ? 43 : ((Object)$fieldDtoList).hashCode());
        List<String> $ignores = this.getIgnores();
        result = result * 59 + ($ignores == null ? 43 : ((Object)$ignores).hashCode());
        return result;
    }

    public String toString() {
        return "ItemReadTemplate(logger=" + this.getLogger() + ", readAll=" + this.getReadAll() + ", fieldDtoList=" + this.getFieldDtoList() + ", ignores=" + this.getIgnores() + ")";
    }
}

