/*
 * Decompiled with CFR 0.152.
 */
package cn.wwwlike.vlife.objship.read;

import cn.wwwlike.base.model.IModel;
import cn.wwwlike.vlife.base.BaseRequest;
import cn.wwwlike.vlife.base.Item;
import cn.wwwlike.vlife.base.SaveBean;
import cn.wwwlike.vlife.base.VoBean;
import cn.wwwlike.vlife.objship.dto.BeanDto;
import cn.wwwlike.vlife.objship.dto.EntityDto;
import cn.wwwlike.vlife.objship.dto.ReqDto;
import cn.wwwlike.vlife.objship.dto.SaveDto;
import cn.wwwlike.vlife.objship.dto.VoDto;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GlobalData {
    private static final Map<Class, SaveDto> saves = new HashMap<Class, SaveDto>();
    private static final Map<Class, EntityDto> entitys = new HashMap<Class, EntityDto>();
    private static final Map<Class, VoDto> vos = new HashMap<Class, VoDto>();
    private static final Map<Class, ReqDto> reqs = new HashMap<Class, ReqDto>();

    public static Map<Class, EntityDto> getEntityDtos() {
        return entitys;
    }

    public static Map<Class, VoDto> getVoDtos() {
        return vos;
    }

    public static Map<Class, ReqDto> getReqDtos() {
        return reqs;
    }

    public static Map<Class, SaveDto> getSaveDtos() {
        return saves;
    }

    public static void clear() {
        saves.clear();
        entitys.clear();
        vos.clear();
        reqs.clear();
    }

    public static <T extends BeanDto> void save(List<T> dtos) {
        for (BeanDto dto : dtos) {
            if (dto instanceof SaveDto) {
                saves.put(dto.getClz(), (SaveDto)dto);
                continue;
            }
            if (dto instanceof VoDto) {
                vos.put(dto.getClz(), (VoDto)dto);
                continue;
            }
            if (dto instanceof EntityDto) {
                entitys.put(dto.getClz(), (EntityDto)dto);
                continue;
            }
            if (!(dto instanceof ReqDto)) continue;
            reqs.put(dto.getClz(), (ReqDto)dto);
        }
    }

    public static <T extends IModel, D extends BeanDto<T>> D get(Class<T> clazz) {
        if (SaveBean.class.isAssignableFrom(clazz)) {
            return (D)GlobalData.saveDto(clazz);
        }
        if (VoBean.class.isAssignableFrom(clazz)) {
            return (D)GlobalData.voDto(clazz);
        }
        if (BaseRequest.class.isAssignableFrom(clazz)) {
            return (D)GlobalData.reqDto(clazz);
        }
        if (Item.class.isAssignableFrom(clazz)) {
            return (D)GlobalData.entityDto(clazz);
        }
        return null;
    }

    public static EntityDto entityDto(Class<? extends Item> entityClz) {
        EntityDto entityDto = entitys.get(entityClz);
        return entityDto;
    }

    public static EntityDto entityDto(String entityClzStr) {
        Set<Class> set = entitys.keySet();
        for (Class clz : set) {
            if (!clz.getSimpleName().equalsIgnoreCase(entityClzStr)) continue;
            return GlobalData.entityDto(clz);
        }
        return null;
    }

    public static VoDto voDto(Class<? extends VoBean> dtoClz) {
        VoDto dto = vos.get(dtoClz);
        return dto;
    }

    public static ReqDto reqDto(Class<? extends BaseRequest> reqClz) {
        ReqDto dto = reqs.get(reqClz);
        return dto;
    }

    public static SaveDto saveDto(Class<? extends SaveBean> saveClz) {
        SaveDto dto = saves.get(saveClz);
        return dto;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlobalData)) {
            return false;
        }
        GlobalData other = (GlobalData)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof GlobalData;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "GlobalData()";
    }
}

