/*
 * Decompiled with CFR 0.152.
 */
package cn.wwwlike.vlife.objship.read;

import cn.wwwlike.vlife.annotation.VField;
import cn.wwwlike.vlife.base.Item;
import cn.wwwlike.vlife.dict.Opt;
import cn.wwwlike.vlife.objship.dto.BeanDto;
import cn.wwwlike.vlife.objship.dto.FieldDto;
import cn.wwwlike.vlife.objship.dto.ReqDto;
import cn.wwwlike.vlife.objship.read.ItemReadTemplate;
import cn.wwwlike.vlife.objship.read.Read;
import cn.wwwlike.vlife.query.DataExpressTran;
import cn.wwwlike.vlife.utils.GenericsUtils;
import cn.wwwlike.vlife.utils.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class FieldRead
implements Read {
    private FieldDto dto = null;
    private List<FieldDto> ids = new ArrayList<FieldDto>();

    public static FieldRead getInstance() {
        return FieldReadInstance.INSTANCE;
    }

    public static Field match(Class itemClazz, String findFieldName) {
        Field[] fields;
        Field eqF;
        if (findFieldName.endsWith("$")) {
            findFieldName = findFieldName.substring(0, findFieldName.length() - 1);
        }
        if ((eqF = ReflectionUtils.getAccessibleFieldByClass(itemClazz, findFieldName)) != null) {
            return eqF;
        }
        for (Field f : fields = itemClazz.getFields()) {
            String fieldName = f.getName();
            if (fieldName.endsWith("$")) {
                fieldName = fieldName.substring(0, fieldName.length() - 1);
            }
            String entityName = itemClazz.getSimpleName();
            if (fieldName.equalsIgnoreCase(findFieldName)) {
                return f;
            }
            if ((entityName + fieldName).equalsIgnoreCase(findFieldName)) {
                return f;
            }
            if (!fieldName.equalsIgnoreCase(entityName + findFieldName)) continue;
            return f;
        }
        return null;
    }

    public <DTO extends BeanDto> FieldDto read(Field field, DTO itemDto) {
        this.dto = new FieldDto();
        this.dto.setItemDto(itemDto);
        this.dto.setFieldType(ItemReadTemplate.getClzType(field.getType()));
        this.dto.setFieldName(field.getName());
        if (!"list".equals(this.dto.getFieldType())) {
            this.dto.setType(StringUtils.uncapitalize((String)field.getType().getSimpleName()));
            this.dto.setClz(field.getType());
            this.dto.setItemClz(itemDto.getClz());
        } else {
            Class clz = GenericsUtils.getFieldGenericType(field, 0);
            this.dto.setClz(clz);
            this.dto.setItemClz(itemDto.getClz());
            if (Object.class != clz) {
                this.dto.setType(StringUtils.uncapitalize((String)clz.getSimpleName()));
            } else {
                this.dto.setState("-1");
            }
        }
        Class entityClz = itemDto.getClz();
        if (!Item.class.isAssignableFrom(entityClz)) {
            entityClz = GenericsUtils.getGenericType(entityClz);
        }
        if (itemDto instanceof ReqDto) {
            this.setFiledDefaultFilterType(this.dto);
        }
        VField f = field.getAnnotation(VField.class);
        Field mapField = null;
        if (f != null) {
            this.dto.setVField(f);
            if (f.tran() != DataExpressTran.class) {
                try {
                    this.dto.setTran(f.tran().newInstance());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (StringUtils.isNotBlank((CharSequence)f.pathName())) {
                this.dto.setPathName(f.pathName());
            }
            if (f.opt() != Opt.VOID) {
                this.dto.setOpt(f.opt());
            }
            if (StringUtils.isNotBlank((CharSequence)f.dictCode())) {
                this.dto.setDictCode(f.dictCode());
            }
            if (f.orders() != null) {
                this.dto.setOrders(f.orders());
            }
        }
        if ((mapField = FieldRead.match(entityClz, this.dto.getPathName())) != null) {
            this.dto.setEntityClz(entityClz);
            this.dto.setQueryPath(entityClz);
            this.dto.setEntityType(StringUtils.uncapitalize((String)entityClz.getSimpleName()));
            this.dto.setEntityFieldName(mapField.getName());
        }
        return this.dto;
    }

    public void setFiledDefaultFilterType(FieldDto dto) {
        String type = dto.getFieldType();
        Class clz = dto.getClz();
        if (type.equals("list")) {
            if (clz == Date.class || clz == Double.class || clz == Integer.class || clz == Long.class) {
                dto.setOpt(Opt.between);
            } else {
                dto.setOpt(Opt.in);
            }
        } else {
            dto.setOpt(Opt.eq);
        }
    }

    private static class FieldReadInstance {
        private static final FieldRead INSTANCE = new FieldRead();

        private FieldReadInstance() {
        }
    }
}

