/*
 * Decompiled with CFR 0.152.
 */
package cn.wwwlike.vlife.objship.read;

import cn.wwwlike.vlife.annotation.VClazz;
import cn.wwwlike.vlife.base.Item;
import cn.wwwlike.vlife.objship.dto.EntityDto;
import cn.wwwlike.vlife.objship.dto.FieldDto;
import cn.wwwlike.vlife.objship.read.FieldRead;
import cn.wwwlike.vlife.objship.read.ItemReadTemplate;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public class EntityRead
extends ItemReadTemplate<EntityDto> {
    private static String model = "publish";

    public static EntityRead getInstance() {
        EntityRead read = EntityReadInstance.INSTANCE;
        read.readTitleJson(model);
        return read;
    }

    public static EntityRead getPluginInstance() {
        EntityRead read = EntityReadPluginInstance.INSTANCE;
        model = "plugin";
        read.readTitleJson(model);
        return read;
    }

    @Override
    public EntityDto readInfo(Class s) {
        if (Item.class.isAssignableFrom(s) && s != Item.class) {
            EntityDto dto = new EntityDto();
            this.superRead(dto, s);
            dto.setItemType("entity");
            dto.setEntityType(s.getSimpleName());
            dto.setOrders("createDate_desc");
            VClazz f = s.getAnnotation(VClazz.class);
            if (f != null) {
                dto.deleteMap = new HashMap<Class<? extends Item>, String>();
                if (f.remove() != null) {
                    Arrays.stream(f.remove()).forEach(clz -> dto.deleteMap.put((Class<? extends Item>)clz, "remove"));
                }
                if (f.clear() != null) {
                    Arrays.stream(f.clear()).forEach(clz -> dto.deleteMap.put((Class<? extends Item>)clz, "clear"));
                }
                if (f.nothing() != null) {
                    Arrays.stream(f.nothing()).forEach(clz -> dto.deleteMap.put((Class<? extends Item>)clz, "nothing"));
                }
                if (f.unableRm() != null) {
                    Arrays.stream(f.unableRm()).forEach(clz -> dto.deleteMap.put((Class<? extends Item>)clz, "unable"));
                }
                if (f.orders() != null) {
                    dto.setOrders(f.orders());
                }
            }
            return dto;
        }
        return null;
    }

    @Override
    public void relation() {
        for (EntityDto item : this.readAll) {
            ArrayList<FieldDto> fkFields = new ArrayList<FieldDto>();
            if (!item.getState().equals("-1")) {
                for (FieldDto<Object> fieldDto : item.getFields()) {
                    if (!fieldDto.getPathName().endsWith("Id")) continue;
                    String type = fieldDto.getPathName().substring(0, fieldDto.getPathName().length() - 2);
                    this.readAll.forEach(entityDto -> {
                        if (entityDto.getType().equalsIgnoreCase(type)) {
                            fieldDto.setEntityClz(entityDto.getClz());
                            fieldDto.setEntityType(StringUtils.uncapitalize((String)entityDto.getClz().getSimpleName()));
                            fieldDto.setEntityFieldName("id");
                            fkFields.add(fieldDto);
                            item.getFkMap().put(fieldDto.getEntityClz(), fieldDto.getFieldName());
                            this.readAll.forEach(entityDto1 -> {
                                if (entityDto1.clz == entityDto.getClz()) {
                                    entityDto1.getRelationFields().add(fieldDto);
                                }
                            });
                        }
                    });
                }
            }
            item.setFkFields(fkFields);
            for (FieldDto<Object> fieldDto : fkFields) {
                for (FieldDto fieldDto2 : item.getFields()) {
                    if (!fieldDto2.getPathName().startsWith(fieldDto.getEntityType()) || fieldDto2.getPathName().endsWith("Id") || fieldDto2.getPathName().endsWith("id")) continue;
                    Field matchF = FieldRead.match(fieldDto.getEntityClz(), fieldDto2.getPathName());
                    if (matchF == null && fieldDto2.getEntityFieldName() == null) {
                        fieldDto2.setState("-1");
                    }
                    if (matchF == null) continue;
                    fieldDto2.setEntityClz(fieldDto.getEntityClz());
                    fieldDto2.setEntityType(fieldDto.getEntityType());
                    fieldDto2.setEntityFieldName(matchF.getName());
                }
            }
        }
        ItemReadTemplate.infos = this.readAll;
    }

    private static class EntityReadPluginInstance {
        private static EntityRead INSTANCE = new EntityRead();

        private EntityReadPluginInstance() {
        }
    }

    private static class EntityReadInstance {
        private static final EntityRead INSTANCE = new EntityRead();

        private EntityReadInstance() {
        }
    }
}

