/*
 * Decompiled with CFR 0.152.
 */
package cn.wwwlike.vlife.core.dsl;

import cn.wwwlike.base.model.IdBean;
import cn.wwwlike.vlife.base.BaseRequest;
import cn.wwwlike.vlife.base.Item;
import cn.wwwlike.vlife.base.VoBean;
import cn.wwwlike.vlife.core.dsl.QModel;
import cn.wwwlike.vlife.core.dsl.QueryHelper;
import cn.wwwlike.vlife.dict.Join;
import cn.wwwlike.vlife.dict.Opt;
import cn.wwwlike.vlife.objship.dto.EntityDto;
import cn.wwwlike.vlife.objship.dto.FieldDto;
import cn.wwwlike.vlife.objship.dto.ReqDto;
import cn.wwwlike.vlife.objship.dto.VoDto;
import cn.wwwlike.vlife.objship.read.GlobalData;
import cn.wwwlike.vlife.query.AbstractWrapper;
import cn.wwwlike.vlife.query.QueryWrapper;
import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.ComparableExpression;
import com.querydsl.core.types.dsl.ComparableExpressionBase;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.ReflectionUtils;

public class VoModel<T extends Item>
extends QueryHelper
implements QModel<T> {
    private JPAQueryFactory factory;
    private Class<? extends IdBean> vo;
    private EntityPathBase main;
    private EntityPathBase lastEntityPath;
    private Map<String, EntityPathBase> voJoin = new HashMap<String, EntityPathBase>();
    private Map<String, EntityPathBase> alljoin = new HashMap<String, EntityPathBase>();
    private JPAQuery voFromQuery;
    private JPAQuery filterQuery;
    private String prefix = "";

    public VoModel(JPAQueryFactory factory, Class<? extends IdBean> vo, String prefix) {
        this.prefix = prefix;
        this.factory = factory;
        this.vo = vo;
        this.voFromQuery = this.from(vo);
        if (VoBean.class.isAssignableFrom(vo)) {
            Expression[] selects = this.selectExpression();
            if (selects.length > 1) {
                this.voFromQuery.select(selects);
            } else {
                this.voFromQuery.select(selects[0]);
            }
        }
        this.voJoin.putAll(this.alljoin);
    }

    public VoModel(JPAQueryFactory factory, Class<? extends IdBean> vo) {
        this(factory, vo, "");
    }

    public VoModel(JPAQueryFactory factory) {
        this.factory = factory;
    }

    @Override
    public JPAQuery getVoFromQuery() {
        return this.voFromQuery;
    }

    public JPAQuery from(Class<? extends IdBean> vo) {
        if (Item.class.isAssignableFrom(vo)) {
            this.main = VoModel.getItemEntityPath(vo, this.getPrefix() + StringUtils.uncapitalize((String)vo.getSimpleName()));
            this.addJoin(this.main);
            return this.factory.from((EntityPath)this.main);
        }
        VoDto voDto = GlobalData.voDto(vo);
        return this.joinByVo(voDto.getLeftPathClz());
    }

    public JPAQuery joinByVo(List<List<Class<? extends Item>>> lefts) {
        return this.joinByVo(null, null, this.getPrefix(), lefts.toArray(new List[lefts.size()]));
    }

    private BooleanExpression subQueryFilter(String prefix, StringPath mainId, AbstractWrapper wrapper) {
        wrapper.eq("status", "1");
        List<Class<Item>> ls = wrapper.allLeftPath().get(0);
        JPAQuery subMainQuery = this.joinByVo(null, null, prefix + "_", ls);
        BooleanBuilder subBuilder = this.whereByWrapper(wrapper);
        Class<Item> mainClz = wrapper.getMainClzPath().get(wrapper.getMainClzPath().size() - 1);
        Class subMain = wrapper.getEntityClz();
        String entityAlias = prefix + "__" + StringUtils.uncapitalize((String)subMain.getSimpleName());
        EntityPathBase subMainPath = this.getAlljoin().get(entityAlias);
        EntityDto subMainDto = GlobalData.entityDto(subMain);
        StringPath subId = (StringPath)cn.wwwlike.vlife.utils.ReflectionUtils.getFieldValue(subMainPath, subMainDto.getFkMap().get(mainClz));
        subMainQuery.select((Expression)subId);
        if (subBuilder.hasValue()) {
            subMainQuery.where((Predicate)subBuilder);
        }
        return mainId.in((SubQueryExpression)subMainQuery);
    }

    public JPAQuery joinByVo(JPAQuery fromQuery, EntityDto entityDto, String prefix, List<Class<? extends Item>> ... lefts) {
        EntityPathBase rightPath = null;
        String entityAlias = "";
        Class<? extends Item> mainClz = null;
        for (List<Class<? extends Item>> left : lefts) {
            mainClz = left.get(0);
            entityAlias = (StringUtils.isNotBlank((CharSequence)prefix) && !prefix.endsWith("$") ? prefix + "_" : prefix) + StringUtils.uncapitalize((String)mainClz.getSimpleName());
            rightPath = VoModel.getItemEntityPath(mainClz, entityAlias);
            if (fromQuery == null) {
                this.addJoin(rightPath);
                fromQuery = this.factory.from((EntityPath)rightPath);
            } else if (this.alljoin.get(entityAlias) == null) {
                this.addJoin(rightPath);
                String leftIdName = entityDto.getFkMap().get(mainClz);
                StringPath leftId = (StringPath)cn.wwwlike.vlife.utils.ReflectionUtils.getFieldValue(this.alljoin.get(prefix), leftIdName);
                StringPath rightId = (StringPath)cn.wwwlike.vlife.utils.ReflectionUtils.getFieldValue(rightPath, "id");
                fromQuery.leftJoin((EntityPath)rightPath).on((Predicate)leftId.eq((Expression)rightId));
            }
            if (left.size() <= 1) continue;
            fromQuery = this.joinByVo(fromQuery, GlobalData.entityDto(mainClz), entityAlias, left.subList(1, left.size()));
        }
        return fromQuery;
    }

    public void addJoin(EntityPathBase path) {
        if (this.main == null) {
            this.main = path;
        }
        this.lastEntityPath = path;
        this.alljoin.put(path.toString(), path);
    }

    public Expression[] selectExpression() {
        VoDto voDto = GlobalData.voDto(this.getVo());
        ArrayList<SimpleExpression> paths = new ArrayList<SimpleExpression>();
        List list = voDto.getFields().stream().filter(fieldDto -> {
            String type = fieldDto.getFieldType();
            return "basic".equals(type);
        }).collect(Collectors.toList());
        for (FieldDto fieldDto2 : list) {
            EntityPathBase fieldInPath = this.getAlljoin().get(fieldDto2.leftJoinName());
            try {
                Object fieldExpression = (SimpleExpression)cn.wwwlike.vlife.utils.ReflectionUtils.getFieldValue(fieldInPath, fieldDto2.getEntityFieldName());
                if (fieldDto2.getTran() != null) {
                    fieldExpression = fieldDto2.getTran().tran(fieldExpression);
                }
                fieldExpression = fieldExpression.as(fieldDto2.getFieldName());
                paths.add((SimpleExpression)fieldExpression);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        QBean voSxpression = Projections.bean(voDto.getClz(), (Expression[])((Expression[])paths.toArray(new ComparableExpressionBase[paths.size()])));
        Object[] loseExpression = new Expression[voDto.getLoseIds().size()];
        for (String loseFieldName : voDto.getLoseIds().keySet()) {
            ComparableExpression fieldExpression = (ComparableExpression)cn.wwwlike.vlife.utils.ReflectionUtils.getFieldValue(this.getMain(), loseFieldName);
            loseExpression[voDto.getLoseIds().get((Object)loseFieldName).intValue()] = fieldExpression;
        }
        Expression[] all = (Expression[])ArrayUtils.add((Object[])loseExpression, (int)0, (Object)voSxpression);
        return all;
    }

    public <W extends AbstractWrapper<T, String, QueryWrapper<T>>> BooleanBuilder whereByWrapper(W wrapper) {
        BooleanBuilder booleanBuilder = new BooleanBuilder();
        for (AbstractWrapper.Element element : wrapper.getElements()) {
            EntityPathBase path = this.alljoin.get(this.getPrefix() + element.queryPathNames());
            BooleanExpression filterExp = this.filter(path, (String)element.getColumn(), element);
            if (filterExp == null) continue;
            if (wrapper.getJoin() == Join.and) {
                booleanBuilder.and((Predicate)filterExp);
                continue;
            }
            booleanBuilder.or((Predicate)filterExp);
        }
        for (QueryWrapper queryWrapper : wrapper.getSubQuery()) {
            String mainLeftJoinName = queryWrapper.lethJoinName();
            EntityPathBase leftDslPath = this.alljoin.get(mainLeftJoinName);
            BooleanExpression booleanExpression = this.subQueryFilter(mainLeftJoinName, (StringPath)cn.wwwlike.vlife.utils.ReflectionUtils.getFieldValue(leftDslPath, "id"), queryWrapper);
            if (wrapper.getJoin() == Join.and) {
                booleanBuilder.and((Predicate)booleanExpression);
                continue;
            }
            booleanBuilder.or((Predicate)booleanExpression);
        }
        for (QueryWrapper queryWrapper : wrapper.getChilds()) {
            BooleanBuilder builder = this.whereByWrapper(queryWrapper);
            if (wrapper.getJoin() == Join.and) {
                booleanBuilder.and((Predicate)builder);
                continue;
            }
            booleanBuilder.or((Predicate)builder);
        }
        return booleanBuilder;
    }

    public String getPrefix() {
        if (StringUtils.isNotBlank((CharSequence)this.prefix)) {
            return this.prefix + "$";
        }
        return "";
    }

    public <R extends BaseRequest> JPAQuery addQueryFilterJoin(JPAQuery jpaQuery, List<FieldDto> fieldDtos) {
        for (FieldDto reqFieldDto : fieldDtos) {
            Object o;
            String leftJoinName = this.getPrefix() + reqFieldDto.leftJoinName();
            if (leftJoinName == null || this.alljoin.get(leftJoinName) != null || !((o = reqFieldDto.getQueryPath().get(0)) instanceof Class)) continue;
            Class<Item> item = reqFieldDto.leftJoinPath().get(0);
            this.joinByVo(jpaQuery, GlobalData.entityDto(item), this.getPrefix(), reqFieldDto.leftJoinPath());
        }
        return jpaQuery;
    }

    public <R extends AbstractWrapper> JPAQuery addQueryFilterJoin(JPAQuery jpaQuery, R request) {
        List<List<Class<Item>>> allReqLeftPath = request.allLeftPath();
        for (List<Class<Item>> path : allReqLeftPath) {
            Class<Item> item = path.get(0);
            this.joinByVo(jpaQuery, GlobalData.entityDto(item), this.getPrefix(), path);
        }
        return jpaQuery;
    }

    @Override
    public synchronized <R extends AbstractWrapper> JPAQuery fromWhere(R wrapper) {
        wrapper.eq((String)"status", "1");
        this.filterQuery = (JPAQuery)this.getVoFromQuery().clone();
        this.alljoin.clear();
        this.alljoin.putAll(this.voJoin);
        this.filterQuery = this.addQueryFilterJoin(this.filterQuery, wrapper);
        this.filterQuery.where((Predicate)this.whereByWrapper(wrapper));
        return this.filterQuery;
    }

    @Override
    public ReqDto getReqDto(Class<? extends BaseRequest<T>> reqClz) {
        return GlobalData.reqDto(reqClz);
    }

    public BooleanExpression eqfilter(EntityPathBase path, String fieldName, Object val) {
        ComparableExpression fieldlDsl = (ComparableExpression)cn.wwwlike.vlife.utils.ReflectionUtils.getFieldValue(path, fieldName);
        return fieldlDsl.eq(val);
    }

    public BooleanExpression filter(EntityPathBase path, String fieldName, AbstractWrapper.Element element) {
        Object fieldlDsl = (SimpleExpression)cn.wwwlike.vlife.utils.ReflectionUtils.getFieldValue(path, fieldName == null ? "id" : fieldName);
        if (element.getTran() != null) {
            fieldlDsl = element.getTran().tran(fieldlDsl);
        }
        Opt opt = element.getOpt();
        Object[] vals = element.getVals();
        Method method = null;
        BooleanExpression re = null;
        if (fieldlDsl != null) {
            if (element.getVal() != null || element.getVals() != null) {
                if (opt == Opt.between) {
                    method = cn.wwwlike.vlife.utils.ReflectionUtils.findMethod(fieldlDsl.getClass(), opt.name(), vals[0].getClass(), vals[1].getClass());
                    re = (BooleanExpression)ReflectionUtils.invokeMethod((Method)method, (Object)fieldlDsl, (Object[])new Object[]{vals[0], vals[1]});
                } else if (opt == Opt.in) {
                    re = fieldlDsl.in(vals);
                } else {
                    method = cn.wwwlike.vlife.utils.ReflectionUtils.findMethod(fieldlDsl.getClass(), opt.name(), element.getVal().getClass());
                    re = (BooleanExpression)ReflectionUtils.invokeMethod((Method)method, (Object)fieldlDsl, (Object[])new Object[]{element.getVal()});
                }
            } else if (opt == Opt.isNotNull || opt == Opt.isNull) {
                method = cn.wwwlike.vlife.utils.ReflectionUtils.findMethod(fieldlDsl.getClass(), opt.name(), new Class[0]);
                re = (BooleanExpression)ReflectionUtils.invokeMethod((Method)method, (Object)fieldlDsl);
            }
        }
        return re;
    }

    public JPAQueryFactory getFactory() {
        return this.factory;
    }

    public Class<? extends IdBean> getVo() {
        return this.vo;
    }

    @Override
    public EntityPathBase getMain() {
        return this.main;
    }

    public EntityPathBase getLastEntityPath() {
        return this.lastEntityPath;
    }

    public Map<String, EntityPathBase> getVoJoin() {
        return this.voJoin;
    }

    @Override
    public Map<String, EntityPathBase> getAlljoin() {
        return this.alljoin;
    }

    public JPAQuery getFilterQuery() {
        return this.filterQuery;
    }
}

