/*
 * Decompiled with CFR 0.152.
 */
package cn.wwwlike.vlife.core.dsl;

import cn.wwwlike.base.model.IdBean;
import cn.wwwlike.vlife.base.Item;
import cn.wwwlike.vlife.base.Order;
import cn.wwwlike.vlife.base.OrderRequest;
import cn.wwwlike.vlife.base.PageableRequest;
import cn.wwwlike.vlife.base.SaveBean;
import cn.wwwlike.vlife.base.VoBean;
import cn.wwwlike.vlife.bean.PageVo;
import cn.wwwlike.vlife.core.DataProcess;
import cn.wwwlike.vlife.core.VLifeDao;
import cn.wwwlike.vlife.core.dsl.QModel;
import cn.wwwlike.vlife.core.dsl.QueryHelper;
import cn.wwwlike.vlife.core.dsl.VoModel;
import cn.wwwlike.vlife.core.dsl.WModel;
import cn.wwwlike.vlife.core.dsl.WriteModel;
import cn.wwwlike.vlife.dict.Opt;
import cn.wwwlike.vlife.objship.base.ItemInfo;
import cn.wwwlike.vlife.objship.dto.BeanDto;
import cn.wwwlike.vlife.objship.dto.EntityDto;
import cn.wwwlike.vlife.objship.dto.FieldDto;
import cn.wwwlike.vlife.objship.dto.VoDto;
import cn.wwwlike.vlife.objship.read.GlobalData;
import cn.wwwlike.vlife.query.CustomQuery;
import cn.wwwlike.vlife.query.QueryWrapper;
import cn.wwwlike.vlife.query.req.PageQuery;
import cn.wwwlike.vlife.utils.GenericsUtils;
import cn.wwwlike.vlife.utils.ReflectionUtils;
import cn.wwwlike.vlife.utils.VlifeUtils;
import com.querydsl.core.QueryResults;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.ComparableExpressionBase;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.data.domain.Sort;

public class DslDao<T extends Item>
extends QueryHelper
implements VLifeDao<T> {
    public EntityDto entityDto;
    public Map<Class<? extends IdBean>, QModel> models = new HashMap<Class<? extends IdBean>, QModel>();
    public Map<Class<? extends IdBean>, WModel> wModels = new HashMap<Class<? extends IdBean>, WModel>();
    protected JPAQueryFactory factory;
    @PersistenceContext
    protected EntityManager em;
    protected Class<T> entityClz;

    @PostConstruct
    public void init() throws ClassNotFoundException {
        this.entityClz = GenericsUtils.getSuperClassGenricType(this.getClass());
        this.entityDto = GlobalData.entityDto(this.entityClz);
        this.factory = new JPAQueryFactory(this.em);
    }

    protected QModel select(Class<? extends IdBean> voClz) {
        if (this.models.get(voClz) == null) {
            this.models.put(voClz, new VoModel(this.factory, voClz));
        }
        return this.models.get(voClz);
    }

    protected QModel selectNew(Class<? extends IdBean> vo, String prefix) {
        return new VoModel(this.factory, vo, prefix);
    }

    private WModel edit(Class<? extends IdBean> dto) {
        if (this.wModels.get(dto) == null) {
            this.wModels.put(dto, new WriteModel(this.factory, dto));
        } else {
            this.wModels.get(dto).resetClause();
        }
        return this.wModels.get(dto);
    }

    protected <E extends IdBean> JPAQuery dslQuery(Class<E> entityVoClz, QueryWrapper<? extends Item> wrapper, PageableRequest page, OrderRequest order) {
        QModel model = this.select(entityVoClz);
        JPAQuery query = model.fromWhere(wrapper);
        if (page != null) {
            query = this.page(query, page);
        }
        if (order == null || order.getOrderReqList().size() == 0) {
            if (order == null) {
                order = new OrderRequest();
            }
            BeanDto sort = null;
            sort = Item.class.isAssignableFrom(entityVoClz) ? GlobalData.entityDto(entityVoClz) : GlobalData.voDto(entityVoClz);
            order.setOrders(sort.getOrders());
        }
        query = this.order(model.getMain(), query, order.getOrderReqList());
        return query;
    }

    private <E extends VoBean> List<E> query(Class<E> vo, QueryWrapper<? extends Item> wrapper, PageableRequest page, OrderRequest order, Boolean isMainQuery) {
        VoDto voDto;
        List mainResult = this.dslQuery(vo, wrapper, page, order).fetch();
        if (mainResult.size() > 0) {
            this.iocQuery(vo, mainResult);
        }
        if ((voDto = GlobalData.voDto(vo)).getLoseIds().size() > 0 && isMainQuery.booleanValue()) {
            List tuplesResult = mainResult;
            mainResult = tuplesResult.stream().map(v -> v.get(0, Object.class)).collect(Collectors.toList());
        }
        return mainResult;
    }

    private <E extends IdBean> List<E> find(Class<E> entityVoClz, QueryWrapper<? extends Item> wrapper, PageableRequest page, OrderRequest order) {
        if (Item.class.isAssignableFrom(entityVoClz)) {
            return this.dslQuery(entityVoClz, wrapper, page, order).fetch();
        }
        return this.query(entityVoClz, wrapper, page, order, true);
    }

    @Override
    public Long count(QueryWrapper<T> wrapper) {
        return this.dslQuery(this.entityClz, wrapper, null, null).fetchCount();
    }

    @Override
    public <W extends QueryWrapper<T>, R extends CustomQuery<T, W>> Long count(R request) {
        return this.dslQuery(this.entityClz, (QueryWrapper)request.qw(), null, null).fetchCount();
    }

    @Override
    public <W extends QueryWrapper<T>, R extends CustomQuery<T, W>> List<T> find(R request) {
        return this.dslQuery(this.entityClz, (QueryWrapper)request.qw(), null, request.getOrder()).fetch();
    }

    @Override
    public List<T> find(QueryWrapper<T> wq) {
        return this.find(this.entityClz, wq, null, null);
    }

    @Override
    public <E extends PageQuery<T>> PageVo<T> findPage(E pageRequest) {
        QueryResults queryResults = this.dslQuery(this.entityClz, (QueryWrapper)pageRequest.qw(this.entityClz), pageRequest.getPager(), pageRequest.getOrder()).fetchResults();
        List list = queryResults.getResults();
        return new PageVo(list, pageRequest.getPager().getSize(), pageRequest.getPager().getPage(), queryResults.getTotal());
    }

    @Override
    public <E extends VoBean<T>, N extends PageQuery<T>> PageVo<E> queryPage(Class<E> vo, N pageRequest) {
        QueryResults queryResults = this.dslQuery(vo, (QueryWrapper)pageRequest.qw(this.entityClz), pageRequest.getPager(), pageRequest.getOrder()).fetchResults();
        List mainResult = queryResults.getResults();
        VoDto voDto = GlobalData.voDto(vo);
        if (mainResult.size() > 0) {
            this.iocQuery(vo, mainResult);
        }
        if (voDto.getLoseIds().size() > 0) {
            List tuplesResult = mainResult;
            mainResult = tuplesResult.stream().map(v -> v.get(0, Object.class)).collect(Collectors.toList());
        }
        return new PageVo(mainResult, pageRequest.getPager().getSize(), pageRequest.getPager().getPage(), queryResults.getTotal());
    }

    @Override
    public <E extends IdBean> List<E> query(Class<E> entityVoClz, QueryWrapper<? extends Item> wrapper, OrderRequest order) {
        if (VoBean.class.isAssignableFrom(entityVoClz)) {
            return this.query(entityVoClz, wrapper, null, order, true);
        }
        return this.find(entityVoClz, wrapper, null, order);
    }

    @Override
    public <E extends Item> E save(E item) {
        if (item.getId() == null) {
            this.em.persist(item);
        } else {
            this.em.merge(item);
        }
        return item;
    }

    @Override
    public <E extends Item> E save(E item, DataProcess dataProcess) {
        WModel wmodel = this.edit(item.getClass());
        EntityPathBase<? extends Item> saveEntityPath = DslDao.getItemEntityPath(item.getClass());
        if (item.getId() == null) {
            if (dataProcess.getAssigns() != null) {
                Arrays.stream(item.getClass().getFields()).map(Field::getName).filter(name -> !dataProcess.getAssigns().contains(name)).forEach(name -> ReflectionUtils.setFieldValue(item, name, null));
            } else if (dataProcess.getIgnores() != null) {
                Arrays.stream(item.getClass().getFields()).map(Field::getName).filter(name -> dataProcess.getIgnores().contains(name)).forEach(name -> ReflectionUtils.setFieldValue(item, name, null));
            }
            this.em.persist(item);
        } else {
            StringPath idPath = (StringPath)ReflectionUtils.getFieldValue(saveEntityPath, "id");
            wmodel.where(idPath.eq((Object)item.getId()));
            if (dataProcess.getAssigns() != null) {
                wmodel.setValWithAssign(item, dataProcess.getAssigns().toArray(new String[dataProcess.getAssigns().size()]));
            } else {
                wmodel.setVal(item, dataProcess.getIgnores().toArray(new String[dataProcess.getIgnores().size()]));
            }
            Map<String, Object> columnValMap = dataProcess.getColumnValMap();
            columnValMap.forEach((k, v) -> {
                Path fnNameDsl = (Path)ReflectionUtils.getFieldValue(saveEntityPath, k);
                wmodel.getUpdateClause().set(fnNameDsl, v);
            });
            wmodel.getUpdateClause().execute();
        }
        return item;
    }

    @Override
    public <E extends SaveBean> E save(E saveBean, Map<String, Object> fkMap) {
        WModel wmodel = this.edit(saveBean.getClass());
        if (saveBean.getId() != null) {
            Class saveEntityClz = GenericsUtils.getGenericType(saveBean.getClass());
            EntityPathBase<? extends Item> saveEntityPath = DslDao.getItemEntityPath(saveEntityClz);
            StringPath idPath = (StringPath)ReflectionUtils.getFieldValue(saveEntityPath, "id");
            wmodel.where(idPath.eq((Object)saveBean.getId())).setVal(saveBean);
            fkMap.forEach((k, v) -> {
                Path fnNameDsl = (Path)ReflectionUtils.getFieldValue(saveEntityPath, k);
                wmodel.getUpdateClause().set(fnNameDsl, v);
            });
            wmodel.getUpdateClause().execute();
        } else {
            Object item = wmodel.dtoToEntity(saveBean);
            fkMap.forEach((k, v) -> ReflectionUtils.setFieldValue(item, k, v));
            this.save((E)item);
            saveBean.setId(item.getId());
        }
        return saveBean;
    }

    @Override
    public long delete(String id) {
        return this.delete(this.entityClz, id);
    }

    @Override
    public long delete(Class<? extends Item> itemClz, String id) {
        Object item = this.em.find(itemClz, (Object)id);
        if (item != null) {
            this.em.remove(item);
            return 1L;
        }
        return 0L;
    }

    @Override
    public long remove(Class<? extends Item> clazz, String id) {
        Item item = (Item)this.em.find(clazz, (Object)id);
        if (item != null) {
            item.setStatus("0");
            this.em.merge((Object)item);
            return 1L;
        }
        return 0L;
    }

    private JPAQuery page(JPAQuery jQuery, PageableRequest pageRequest) {
        jQuery.offset((long)((pageRequest.getPage() - 1) * pageRequest.getSize()));
        jQuery.limit((long)pageRequest.getSize());
        return jQuery;
    }

    private JPAQuery order(EntityPathBase main, JPAQuery jQuery, List<Order> orderReqList) {
        orderReqList.stream().forEach(order -> {
            Sort.Direction direction = order.getDirection();
            ComparableExpressionBase expression = (ComparableExpressionBase)ReflectionUtils.getFieldValue(main, order.getProperty());
            if (direction.isAscending()) {
                jQuery.orderBy(expression.asc());
            } else {
                jQuery.orderBy(expression.desc());
            }
        });
        return jQuery;
    }

    private void iocQuery(Class<? extends VoBean> vo, List mainResult) {
        if (mainResult.size() > 0) {
            VoDto voDto = GlobalData.voDto(vo);
            List iocFields = voDto.getFields().stream().filter(fieldDto -> !"basic".equals(fieldDto.getFieldType())).collect(Collectors.toList());
            for (FieldDto fieldDto2 : iocFields) {
                boolean iocList;
                boolean bl = iocList = !"entity".equals(fieldDto2.getFieldType()) && !"vo".equals(fieldDto2.getFieldType());
                if (fieldDto2.getPathName().indexOf("_") != -1) {
                    List<Class> pingList = VlifeUtils.queryPathClazzList(fieldDto2.getQueryPath());
                    Class secondLastClz = pingList.get(pingList.size() - 2);
                    EntityDto secondLastEntityDto = GlobalData.entityDto(secondLastClz);
                    String idName = secondLastEntityDto.getFkMap().get(pingList.get(pingList.size() - 1));
                    idName = idName == null ? "id" : idName;
                    List iocQueryPath = VlifeUtils.removeQueryPathLast(fieldDto2.getQueryPath());
                    String mainIdName = idName.equals("id") ? voDto.getEntityDto().getFkMap().get(secondLastClz) : "id";
                    for (Object obj2 : mainResult) {
                        String idVal = this.getObjIdVal(obj2, mainIdName);
                        if (idVal == null) continue;
                        QueryWrapper wq = this.createWrapperFromQueryPath(null, iocQueryPath, idVal, Opt.eq, null, idName);
                        List<Item> sub = null;
                        if (Item.class.isAssignableFrom(fieldDto2.getClz())) {
                            sub = this.query(fieldDto2.getEntityClz(), wq, null);
                        } else if (fieldDto2.getClz().isPrimitive() || fieldDto2.getClz() == Date.class || fieldDto2.getClz() == String.class) {
                            List<Item> items = this.query(fieldDto2.getEntityClz(), wq, null);
                            sub = items.stream().map(db -> {
                                String fieldName = fieldDto2.getEntityFieldName();
                                return ReflectionUtils.getFieldValue(db, fieldName == null ? "id" : fieldName);
                            }).collect(Collectors.toList());
                        } else {
                            sub = this.query(fieldDto2.getClz(), wq, null, null, true);
                        }
                        if (sub == null || sub.size() <= 0) continue;
                        Object setval = sub;
                        if (!iocList) {
                            setval = sub.get(0);
                        }
                        if (obj2 instanceof IdBean) {
                            ReflectionUtils.setFieldValue(obj2, fieldDto2.getFieldName(), setval);
                            continue;
                        }
                        ReflectionUtils.setFieldValue(((Tuple)obj2).get(0, IdBean.class), fieldDto2.getFieldName(), setval);
                    }
                    continue;
                }
                EntityDto mainDto = voDto.getEntityDto();
                EntityDto iocEntityDto = GlobalData.entityDto(fieldDto2.getEntityClz());
                Object[] ids = new Object[mainResult.size()];
                QueryWrapper<Item> wq = QueryWrapper.of(fieldDto2.getEntityClz());
                ids = mainDto.getFkMap().get(fieldDto2.getEntityClz()) != null ? (mainResult.get(0) instanceof IdBean ? mainResult.stream().map(obj -> ReflectionUtils.getFieldValue(obj, mainDto.getFkMap().get(fieldDto2.getEntityClz()))).filter(id -> id != null).toArray() : mainResult.stream().map(obj -> ((Tuple)obj).get(voDto.getLoseIds().get(mainDto.getFkMap().get(fieldDto2.getEntityClz())) + 1, String.class)).filter(id -> id != null).toArray()) : (mainResult.get(0) instanceof IdBean ? mainResult.stream().map(obj -> (String)ReflectionUtils.getFieldValue(obj, "id")).filter(id -> id != null).toArray() : mainResult.stream().map(obj -> ((IdBean)((Tuple)obj).get(0, IdBean.class)).getId()).filter(id -> id != null).toArray());
                if (ids.length == 1) {
                    wq.eq(iocEntityDto.getFkMap().get(mainDto.getClz()), ids[0]);
                } else {
                    wq.in(iocEntityDto.getFkMap().get(mainDto.getClz()), ids);
                }
                List iocResult = null;
                iocResult = Item.class.isAssignableFrom(fieldDto2.getClz()) ? this.find(fieldDto2.getClz(), wq, null, null) : this.query(fieldDto2.getClz(), wq, null, null, false);
                String subId = iocList ? ((ItemInfo)fieldDto2.getItemDto()).getEntityType() + "Id" : "id";
                String parentId = iocList ? "id" : fieldDto2.getEntityType() + "Id";
                this.setListSubBean(voDto, mainResult, iocResult, fieldDto2.getFieldName(), parentId, subId);
            }
        }
    }
}

