/*
 * Decompiled with CFR 0.152.
 */
package cn.wwwlike.vlife.core;

import cn.wwwlike.base.model.IdBean;
import cn.wwwlike.vlife.base.Item;
import cn.wwwlike.vlife.base.OrderRequest;
import cn.wwwlike.vlife.base.SaveBean;
import cn.wwwlike.vlife.base.VoBean;
import cn.wwwlike.vlife.bean.PageVo;
import cn.wwwlike.vlife.core.DataProcess;
import cn.wwwlike.vlife.core.HealthDataProcess;
import cn.wwwlike.vlife.core.VLifeDao;
import cn.wwwlike.vlife.objship.dto.BeanDto;
import cn.wwwlike.vlife.objship.dto.EntityDto;
import cn.wwwlike.vlife.objship.dto.FieldDto;
import cn.wwwlike.vlife.objship.dto.SaveDto;
import cn.wwwlike.vlife.objship.read.GlobalData;
import cn.wwwlike.vlife.query.CustomQuery;
import cn.wwwlike.vlife.query.QueryWrapper;
import cn.wwwlike.vlife.query.req.PageQuery;
import cn.wwwlike.vlife.utils.GenericsUtils;
import cn.wwwlike.vlife.utils.ReflectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class VLifeService<T extends Item, D extends VLifeDao<T>> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    public D dao;
    public Class<T> entityClz;

    public D getDao() {
        return this.dao;
    }

    @PostConstruct
    public void init() throws ClassNotFoundException {
        this.entityClz = GenericsUtils.getSuperClassGenricType(this.getClass());
    }

    public BeanDto modelInfo(String modelName) {
        BeanDto dto = null;
        Optional<Class> t = GlobalData.getEntityDtos().keySet().stream().filter(clz -> clz.getSimpleName().equalsIgnoreCase(modelName)).findAny();
        if (t.isPresent()) {
            dto = GlobalData.entityDto(t.get());
            return dto;
        }
        t = GlobalData.getSaveDtos().keySet().stream().filter(clz -> clz.getSimpleName().equalsIgnoreCase(modelName)).findAny();
        if (t.isPresent()) {
            dto = GlobalData.getSaveDtos().get(t.get());
            return dto;
        }
        t = GlobalData.getVoDtos().keySet().stream().filter(clz -> clz.getSimpleName().equalsIgnoreCase(modelName)).findAny();
        if (t.isPresent()) {
            dto = GlobalData.getVoDtos().get(t.get());
            return dto;
        }
        t = GlobalData.getReqDtos().keySet().stream().filter(clz -> clz.getSimpleName().equalsIgnoreCase(modelName)).findAny();
        if (t.isPresent()) {
            dto = GlobalData.getReqDtos().get(t.get());
            return dto;
        }
        return dto;
    }

    public T findOne(String id) {
        if (id == null) {
            this.logger.error("findOne-> id is null");
            return null;
        }
        QueryWrapper wrapper = (QueryWrapper)QueryWrapper.of(this.entityClz).eq("id", id);
        List list = this.dao.find(wrapper);
        if (list.size() > 0) {
            return (T)((Item)list.get(0));
        }
        return null;
    }

    public List<T> findByIds(String ... ids) {
        if (ids == null || ids.length == 0) {
            this.logger.error("findByIds-> ids is null or length=0");
            return null;
        }
        QueryWrapper wrapper = (QueryWrapper)QueryWrapper.of(this.entityClz).in("id", ids);
        return this.dao.find(wrapper);
    }

    public List<T> findAll() {
        QueryWrapper<T> wrapper = QueryWrapper.of(this.entityClz);
        wrapper = this.addQueryFilter(wrapper);
        return this.dao.find(wrapper);
    }

    public List<T> findAll(OrderRequest order) {
        QueryWrapper<T> wrapper = QueryWrapper.of(this.entityClz);
        wrapper = this.addQueryFilter(wrapper);
        return this.dao.query(this.entityClz, wrapper, order);
    }

    public List<T> find(String property, Object val) {
        QueryWrapper queryWrapper = (QueryWrapper)QueryWrapper.of(this.entityClz).eq(property, val);
        queryWrapper = this.addQueryFilter(queryWrapper);
        return this.dao.find(queryWrapper);
    }

    public <S extends QueryWrapper, E extends CustomQuery<T, S>> List<T> find(E request) {
        request = this.addQueryFilter((S)((Object)request));
        return this.dao.find(request);
    }

    public List<T> find(QueryWrapper<T> qw) {
        qw = this.addQueryFilter(qw);
        return this.dao.find(qw);
    }

    public <S extends QueryWrapper, E extends CustomQuery<T, S>> long count(E request) {
        return this.dao.count((QueryWrapper)((QueryWrapper)request.qw()));
    }

    public <E extends PageQuery<T>> PageVo<T> findPage(E pageRequest) {
        pageRequest = this.addQueryFilter((QueryWrapper)((Object)pageRequest));
        return this.dao.findPage(pageRequest);
    }

    public <E extends VoBean<T>> E queryOne(Class<E> voClz, String id) {
        QueryWrapper wrapper = (QueryWrapper)QueryWrapper.of(this.entityClz).eq("id", id);
        List<E> list = this.dao.query(voClz, wrapper, null);
        if (list != null && list.size() == 1) {
            return (E)((VoBean)list.get(0));
        }
        return null;
    }

    public <E extends VoBean<T>> List<E> queryByIds(Class<E> voClz, String ... ids) {
        if (ids == null || ids.length == 0) {
            this.logger.error("findByIds-> ids is null or length=0");
            return null;
        }
        QueryWrapper wrapper = (QueryWrapper)QueryWrapper.of(this.entityClz).in("id", ids);
        List<E> list = this.dao.query(voClz, wrapper, null);
        return list;
    }

    public <D extends VoBean<T>, S extends QueryWrapper, E extends CustomQuery<T, S>> List<D> query(Class<D> vo, QueryWrapper<T> qw) {
        qw = this.addQueryFilter(qw);
        return this.dao.query(vo, qw, null);
    }

    public <D extends VoBean<T>, S extends QueryWrapper, E extends CustomQuery<T, S>> List<D> query(Class<D> vo, E request) {
        request = this.addQueryFilter((S)((Object)request));
        return this.dao.query(vo, (QueryWrapper)request.qw(this.entityClz), request.getOrder());
    }

    public <D extends VoBean<T>, S extends QueryWrapper, E extends CustomQuery<T, S>> List<D> queryAll(Class<D> vo) {
        QueryWrapper<T> qw = this.addQueryFilter(QueryWrapper.of(this.entityClz));
        return this.dao.query(vo, qw, null);
    }

    public <E extends VoBean<T>, N extends PageQuery<T>> PageVo<E> queryPage(Class<E> vo, N request) {
        request = this.addQueryFilter((QueryWrapper)((Object)request));
        return this.dao.queryPage(vo, request);
    }

    public long remove(String id) {
        if (id == null) {
            this.logger.error("remove-> id is null");
            return 0L;
        }
        return this.remove(this.entityClz, id);
    }

    public long delete(String id) {
        if (id == null) {
            this.logger.error("delete-> id is null");
            return 0L;
        }
        return this.dao.delete(id);
    }

    public long batchDel(String ... ids) {
        if (ids == null || ids.length == 0) {
            this.logger.error("batchDel-> ids is null or length=0");
            return 0L;
        }
        long i = 0L;
        for (String id : ids) {
            i += this.delete(id);
        }
        return i;
    }

    public long batchRm(String ... ids) {
        if (ids == null || ids.length == 0) {
            this.logger.error("batchRm-> ids is null or length=0");
            return 0L;
        }
        long i = 0L;
        for (String id : ids) {
            i += this.remove(this.entityClz, id);
        }
        return i;
    }

    public T save(T beanDto) {
        DataProcess masterProcess = this.createProcess((IdBean)beanDto);
        return this.save((Item)beanDto, masterProcess);
    }

    public T saveWithIgnore(T t, String ... ignores) {
        DataProcess masterProcess = this.createProcess((IdBean)t);
        masterProcess.setIgnores(ignores);
        return this.save((Item)t, masterProcess);
    }

    public T saveWithAssign(T t, String ... assigns) {
        DataProcess masterProcess = this.createProcess((IdBean)t);
        masterProcess.setAssigns(assigns);
        return this.save((Item)t, masterProcess);
    }

    public <E extends SaveBean<T>> E save(E saveBean, boolean isFull) {
        return this.saveBean(saveBean, isFull);
    }

    public <E extends SaveBean<T>> E save(E saveBean) {
        return this.saveBean(saveBean, false);
    }

    public <E extends SaveBean<T>> E save(E t, UnaryOperator<DataProcess> callBackMethod, boolean isfull) {
        return this.saveBean(t, null, null, callBackMethod, isfull);
    }

    public <E extends SaveBean<T>> E save(E t, UnaryOperator<DataProcess> callBackMethod) {
        return this.saveBean(t, null, null, callBackMethod, false);
    }

    private <E extends IdBean> E saveBean(E idBean, boolean isFull) {
        return this.saveBean(idBean, null, null, null, isFull);
    }

    private long remove(Class<? extends Item> itemClz, String id) {
        QueryWrapper wrapper;
        Object[] ids = id.split(",");
        EntityDto entityDto = GlobalData.entityDto(itemClz);
        List<Class<? extends Item>> relationClz = entityDto.getRelationTableClz();
        for (Class<? extends Item> clz : relationClz) {
            String delType = entityDto.getDeleteMap().get(clz);
            if (!"unable".equals(delType) || this.dao.query(clz, wrapper = (QueryWrapper)((QueryWrapper)QueryWrapper.of(clz).eq(ids.length == 1, entityDto.getType() + "Id", id)).in(ids.length > 1, entityDto.getType() + "Id", ids), null).size() <= 0) continue;
            return -1L;
        }
        for (Class<? extends Item> clz : relationClz) {
            List<? extends Item> data;
            EntityDto delEntityDto = GlobalData.entityDto(clz);
            wrapper = new QueryWrapper(clz);
            String string = delEntityDto.getFkMap().get(itemClz);
            if (ids.length > 1) {
                wrapper.in(string, ids);
            } else {
                wrapper.eq(string, id);
            }
            if ((data = this.dao.query(clz, wrapper, null)) == null || data.size() <= 0) continue;
            String deltype = this.delRelation(entityDto, delEntityDto);
            for (Item item : data) {
                if ("remove".equals(deltype)) {
                    long num = this.remove(clz, item.getId());
                    if (num != -1L) continue;
                    return num;
                }
                if (!"clear".equals(deltype)) continue;
                ReflectionUtils.setFieldValue(item, string, null);
                this.dao.save((Item)item);
            }
        }
        if (ids.length > 1) {
            int num = 0;
            for (String string : ids) {
                num = (int)((long)num + this.dao.remove(itemClz, string));
            }
            return num;
        }
        return this.dao.remove(itemClz, id);
    }

    protected <I extends Item> I save(I beanDto, DataProcess masterProcess) {
        EntityDto entityDto = GlobalData.entityDto(beanDto.getClass());
        masterProcess.getColumnValMap().forEach((k, v) -> ReflectionUtils.setFieldValue(beanDto, k, v));
        this.dao.save(beanDto, masterProcess);
        return beanDto;
    }

    protected <E extends IdBean> E saveBean(E beanDto, Class<? extends Item> fkItemClz, String fkItemId, UnaryOperator<DataProcess> callBackMethod, boolean subIsFull) {
        DataProcess masterProcess;
        DataProcess dataProcess = masterProcess = callBackMethod == null ? this.createProcess(beanDto) : (DataProcess)callBackMethod.apply(this.createProcess(beanDto));
        if (beanDto instanceof SaveBean) {
            boolean editModel = beanDto.getId() != null;
            SaveBean saveBean = (SaveBean)beanDto;
            Class entityClz = GenericsUtils.getGenericType(saveBean.getClass());
            EntityDto entityDto = GlobalData.entityDto(entityClz);
            if (fkItemClz != null && fkItemId != null) {
                masterProcess.setVal(entityDto.getFkMap().get(fkItemClz), fkItemId);
            }
            SaveDto saveDto = GlobalData.saveDto(saveBean.getClass());
            saveDto.filter("entity", "save").stream().filter(fieldDto -> {
                Class<Item> fkClz = fieldDto.getEntityClz();
                return entityDto.getFkTableClz().contains(fkClz) && ReflectionUtils.getFieldValue(saveBean, fieldDto.getFieldName()) != null;
            }).forEach(dto -> {
                IdBean bean = (IdBean)ReflectionUtils.getFieldValue(saveBean, dto.getFieldName());
                bean = this.saveBean(bean, null, null, callBackMethod, false);
                String fkIdName = entityDto.getFkMap().get(dto.getEntityClz());
                masterProcess.setVal(fkIdName, bean.getId());
            });
            String masterId = this.dao.save((SaveBean)saveBean, masterProcess.getColumnValMap()).getId();
            saveDto.filter("entity", "vo", "list").stream().filter(fieldDto -> {
                Class<Item> fkClz = fieldDto.getEntityClz();
                return entityDto.getRelationTableClz().contains(fkClz);
            }).forEach(fieldDto -> {
                Object bean = ReflectionUtils.getFieldValue(saveBean, fieldDto.getFieldName());
                if (subIsFull && editModel) {
                    this.removeRelationEntity((FieldDto)fieldDto, entityDto, saveBean);
                }
                if (bean instanceof IdBean) {
                    this.saveBean((IdBean)bean, entityClz, masterId, callBackMethod, false);
                } else if (bean instanceof List) {
                    for (Object b : (List)bean) {
                        if (b instanceof IdBean) {
                            this.saveBean((IdBean)b, entityClz, masterId, callBackMethod, false);
                            continue;
                        }
                        if (!b.getClass().isPrimitive() && !(b instanceof Date) && !(b instanceof String)) continue;
                        Class<Item> saveClz = fieldDto.getEntityClz();
                        EntityDto itemDto = GlobalData.entityDto(saveClz);
                        if (itemDto.isM2M()) {
                            List<Item> list;
                            Item m2mItem = null;
                            QueryWrapper<Item> req = QueryWrapper.of(saveClz);
                            req.eq(itemDto.getFkMap().get(entityClz), masterId);
                            req.eq(fieldDto.getEntityFieldName(), b);
                            try {
                                m2mItem = saveClz.newInstance();
                                ReflectionUtils.setFieldValue(m2mItem, itemDto.getFkMap().get(entityClz), masterId);
                                ReflectionUtils.setFieldValue(m2mItem, fieldDto.getEntityFieldName(), b);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if ((list = this.dao.query(saveClz, req, null)) != null && list.size() != 0) continue;
                            this.saveBean(m2mItem, null, null, callBackMethod, false);
                            continue;
                        }
                        QueryWrapper<Item> wrapper = QueryWrapper.of(fieldDto.getEntityClz());
                        wrapper.eq("id", b);
                        List<Item> list = this.dao.query(fieldDto.getEntityClz(), wrapper, null);
                        if (list == null || list.size() <= 0) continue;
                        this.saveBean((IdBean)list.get(0), entityClz, masterId, callBackMethod, false);
                    }
                }
            });
            List<Class<? extends Item>> relationItems = entityDto.getRelationTableClz();
            saveDto.filter("list").stream().filter(fieldDto -> {
                Class<Item> fkClz = fieldDto.getEntityClz();
                return !relationItems.contains(fkClz) && fieldDto.getEntityClz() != null;
            }).forEach(fieldDto -> relationItems.forEach(item -> {
                List beans;
                EntityDto m2mDto = GlobalData.entityDto(item);
                String rigthFkName = m2mDto.getFkMap().get(fieldDto.getEntityClz());
                String leftFkName = m2mDto.getFkMap().get(entityClz);
                if (rigthFkName != null && leftFkName != null && m2mDto.isM2M() && (beans = (List)ReflectionUtils.getFieldValue(saveBean, fieldDto.getFieldName())) != null) {
                    List<Object> existDbItem = new ArrayList();
                    if (editModel) {
                        QueryWrapper wrapper = new QueryWrapper(m2mDto.getClz());
                        wrapper.eq(leftFkName, masterId);
                        existDbItem = this.dao.query(m2mDto.getClz(), wrapper, null);
                    }
                    if (subIsFull && editModel) {
                        List commitIds = beans.stream().filter(idBean1 -> idBean1.getId() != null).map(IdBean::getId).collect(Collectors.toList());
                        existDbItem.forEach(db -> {
                            if (!commitIds.contains(ReflectionUtils.getFieldValue(db, rigthFkName))) {
                                this.remove(m2mDto.getClz(), db.getId());
                            }
                        });
                    }
                    for (IdBean b : beans) {
                        String m2mId = this.saveBean(b, null, null, callBackMethod, false).getId();
                        if (existDbItem.stream().map(db -> ReflectionUtils.getFieldValue(db, rigthFkName)).collect(Collectors.toList()).contains(m2mId)) continue;
                        try {
                            Item m2mEntity = (Item)m2mDto.getClz().newInstance();
                            ReflectionUtils.setFieldValue(m2mEntity, leftFkName, masterId);
                            ReflectionUtils.setFieldValue(m2mEntity, rigthFkName, m2mId);
                            this.saveBean(m2mEntity, null, null, callBackMethod, false);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }));
        } else if (beanDto instanceof Item) {
            EntityDto entityDto = GlobalData.entityDto(beanDto.getClass());
            if (fkItemClz != null) {
                ReflectionUtils.setFieldValue(beanDto, entityDto.getFkMap().get(fkItemClz), fkItemId);
            }
            this.save((Item)beanDto, masterProcess);
        }
        return beanDto;
    }

    private List<String> getIds(IdBean ... idBeans) {
        return this.getIdList(Arrays.asList(idBeans), "id");
    }

    private void removeRelationEntity(FieldDto fieldDto, EntityDto entityDto, SaveBean saveBean) {
        Object bean = ReflectionUtils.getFieldValue(saveBean, fieldDto.getFieldName());
        QueryWrapper<Item> wrapper = new QueryWrapper<Item>(fieldDto.getEntityClz());
        Class<Item> subItemClz = fieldDto.getEntityClz();
        EntityDto subEntityDto = GlobalData.entityDto(fieldDto.getEntityClz());
        String fkName = subEntityDto.getFkMap().get(this.entityClz);
        wrapper.eq(fkName, saveBean.getId());
        List<Item> existDb = this.dao.query(subItemClz, wrapper, null);
        ArrayList<String> thisCommitIds = new ArrayList<String>();
        if (bean != null) {
            if (bean instanceof IdBean) {
                thisCommitIds.addAll(this.getIds((IdBean)bean));
            } else if (bean instanceof List) {
                List list = (List)bean;
                if (list.size() > 0 && list.get(0) instanceof IdBean) {
                    thisCommitIds.addAll(this.getIdList(list, "id"));
                }
                if (list.size() > 0 && (list.get(0).getClass().isPrimitive() || list.get(0) instanceof Date || list.get(0) instanceof String)) {
                    thisCommitIds.addAll((List)bean);
                }
            }
        }
        String deltype = this.delRelation(entityDto, subEntityDto);
        existDb.stream().filter(db -> {
            Object id = ReflectionUtils.getFieldValue(db, fieldDto.getEntityFieldName() == null ? "id" : fieldDto.getEntityFieldName());
            return !thisCommitIds.contains(id);
        }).forEach(dbSubItem -> {
            if ("remove".equals(deltype)) {
                this.remove(subItemClz, dbSubItem.getId());
            } else if ("clear".equals(deltype)) {
                ReflectionUtils.setFieldValue(dbSubItem, fkName, null);
                this.dao.save((Item)dbSubItem);
            }
        });
    }

    private List getIdList(List<? extends IdBean> idBeans, String fkIdName) {
        return idBeans.stream().map(bean -> ReflectionUtils.getFieldValue(bean, fkIdName)).filter(str -> str != null).collect(Collectors.toList());
    }

    private String delRelation(EntityDto main, EntityDto del) {
        String delType = main.getDeleteMap().get(del.getClz());
        if (delType == null) {
            boolean delByRule = del.getFkTableClz().size() == 1 || del.isM2M();
            delType = delByRule ? "remove" : "clear";
        }
        return delType;
    }

    protected DataProcess createProcess(IdBean bean) {
        return new HealthDataProcess(bean);
    }

    public <S extends QueryWrapper, E extends CustomQuery<T, S>> E addQueryFilter(E request) {
        this.addQueryFilter((QueryWrapper)request.qw(this.entityClz));
        return request;
    }

    public <S extends QueryWrapper> S addQueryFilter(S queryWrapper) {
        return queryWrapper;
    }
}

