/*
 * Decompiled with CFR 0.152.
 */
package cn.wwwlike.vlife.core;

import cn.wwwlike.base.model.IdBean;
import cn.wwwlike.vlife.base.Item;
import cn.wwwlike.vlife.core.VLifeService;
import cn.wwwlike.vlife.objship.dto.BeanDto;
import cn.wwwlike.vlife.query.QueryWrapper;
import cn.wwwlike.vlife.utils.GenericsUtils;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

public class VLifeApi<T extends Item, S extends VLifeService> {
    @Autowired
    public S service;
    public Class<T> entityClz;

    @PostConstruct
    public void init() throws ClassNotFoundException {
        this.entityClz = GenericsUtils.getSuperClassGenricType(this.getClass());
    }

    @GetMapping(value={"/modelInfo/{modelName}"})
    public BeanDto modelInfo(@PathVariable String modelName) {
        return ((VLifeService)this.service).modelInfo(modelName);
    }

    @GetMapping(value={"/view/{modelName}/{id}"})
    public IdBean view(@PathVariable String modelName, @PathVariable String id) {
        BeanDto btn = ((VLifeService)this.service).modelInfo(modelName);
        if (Item.class.isAssignableFrom(btn.getClz())) {
            return ((VLifeService)this.service).findOne(id);
        }
        return ((VLifeService)this.service).queryOne(btn.getClz(), id);
    }

    @GetMapping(value={"/find/{field}"})
    public List<T> find(@PathVariable String field, String ... ids) {
        QueryWrapper qw = (QueryWrapper)QueryWrapper.of(this.entityClz).in(field, ids);
        return ((VLifeService)this.service).find(qw);
    }
}

