/*
 * Decompiled with CFR 0.152.
 */
package cn.wwwlike.vlife.core;

import cn.wwwlike.base.model.IdBean;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public abstract class DataProcess {
    protected Set<String> ignores;
    protected Set<String> assigns;
    private IdBean bean;
    private Map<String, Object> columnValMap = new HashMap<String, Object>();

    public void setIgnores(String ... ignores) {
        if (this.ignores == null) {
            this.ignores = new HashSet<String>();
        }
        if (ignores != null) {
            Arrays.stream(ignores).forEach(s -> this.ignores.add((String)s));
        }
        this.commonDataSet(this.getBean(), this.getColumnValMap());
    }

    public void setAssigns(String[] assigns) {
        if (this.assigns == null) {
            this.assigns = new HashSet<String>();
        }
        if (assigns != null) {
            Arrays.stream(assigns).forEach(s -> this.assigns.add((String)s));
        }
        this.commonDataSet(this.getBean(), this.getColumnValMap());
    }

    public DataProcess(IdBean bean) {
        this.bean = bean;
        this.setIgnores("status", "createDate", "modifyDate", "createId", "modifyId");
        this.commonDataSet(this.getBean(), this.getColumnValMap());
    }

    public DataProcess setVal(boolean condition, String column, Object val) {
        if (condition) {
            this.columnValMap.put(column, val);
        }
        return this;
    }

    public DataProcess setVal(String column, Object val) {
        this.setVal(true, column, val);
        return this;
    }

    public DataProcess setVal(String column, Supplier<Object> supplier) {
        this.setVal(true, column, supplier.get());
        return this;
    }

    public DataProcess setNull(String column) {
        this.setVal(true, column, null);
        return this;
    }

    public DataProcess setNull(boolean condition, String column) {
        this.setVal(condition, column, null);
        return this;
    }

    public abstract void commonDataSet(IdBean var1, Map<String, Object> var2);

    public Set<String> getIgnores() {
        return this.ignores;
    }

    public Set<String> getAssigns() {
        return this.assigns;
    }

    public IdBean getBean() {
        return this.bean;
    }

    public Map<String, Object> getColumnValMap() {
        return this.columnValMap;
    }
}

