/*
 * Decompiled with CFR 0.152.
 */
package cn.wwwlike.vlife.base;

import cn.wwwlike.vlife.base.Order;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.domain.Sort;

public class OrderRequest {
    public String orders;
    public List<Order> orderReqList = new ArrayList<Order>();

    public OrderRequest(String property, Sort.Direction sort) {
        this.addOrder(property, sort);
    }

    public OrderRequest() {
    }

    public void setOrders(String orders) {
        this.orders = orders;
        if (orders != null) {
            String[] orderArray;
            for (String order : orderArray = orders.split(",")) {
                String[] detail = order.split("_");
                if (detail.length == 1) {
                    this.addOrder(detail[0], Sort.Direction.ASC);
                }
                if (detail.length != 2) continue;
                if (detail[1].equalsIgnoreCase("DESC")) {
                    this.addOrder(detail[0], Sort.Direction.DESC);
                    continue;
                }
                if (!detail[1].equalsIgnoreCase("ASC")) continue;
                this.addOrder(detail[0], Sort.Direction.ASC);
            }
        }
    }

    public OrderRequest addOrder(String field, Sort.Direction direction) {
        if (this.orderReqList == null) {
            this.orderReqList = new ArrayList<Order>();
        }
        this.orderReqList.add(new Order(field, direction));
        return this;
    }

    public String getOrders() {
        return this.orders;
    }

    public List<Order> getOrderReqList() {
        return this.orderReqList;
    }

    public void setOrderReqList(List<Order> orderReqList) {
        this.orderReqList = orderReqList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderRequest)) {
            return false;
        }
        OrderRequest other = (OrderRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$orders = this.getOrders();
        String other$orders = other.getOrders();
        if (this$orders == null ? other$orders != null : !this$orders.equals(other$orders)) {
            return false;
        }
        List<Order> this$orderReqList = this.getOrderReqList();
        List<Order> other$orderReqList = other.getOrderReqList();
        return !(this$orderReqList == null ? other$orderReqList != null : !((Object)this$orderReqList).equals(other$orderReqList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrderRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $orders = this.getOrders();
        result = result * 59 + ($orders == null ? 43 : $orders.hashCode());
        List<Order> $orderReqList = this.getOrderReqList();
        result = result * 59 + ($orderReqList == null ? 43 : ((Object)$orderReqList).hashCode());
        return result;
    }

    public String toString() {
        return "OrderRequest(orders=" + this.getOrders() + ", orderReqList=" + this.getOrderReqList() + ")";
    }
}

