/*
 * Decompiled with CFR 0.152.
 */
package wechaty.puppet;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import javax.activation.MimeType;
import org.apache.commons.io.IOUtils;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import wechaty.puppet.ResourceBox$;
import wechaty.puppet.ResourceBox$ResourceBoxType$;
import wechaty.puppet.schemas.Puppet$;

@ScalaSignature(bytes="\u0006\u0001\u0005%x!B A\u0011\u0003)e!B$A\u0011\u0003A\u0005\"B(\u0002\t\u0003\u0001\u0006\"B)\u0002\t\u0003\u0011\u0006bBA\u0006\u0003\u0011\u0005\u0011Q\u0002\u0005\b\u0003'\tA\u0011AA\u000b\u0011\u001d\ti\"\u0001C\u0001\u0003?9q!!\n\u0002\u0011\u0003\t9CB\u0004\u0002,\u0005A\t!!\f\t\r=CA\u0011AA\u001b\u000b\u0019\t9\u0004\u0003\u0001\u0002:!I\u0011\u0011\t\u0005C\u0002\u0013\u0005\u00111\t\u0005\t\u0003\u000fB\u0001\u0015!\u0003\u0002F!I\u0011\u0011\n\u0005C\u0002\u0013\u0005\u00111\t\u0005\t\u0003\u0017B\u0001\u0015!\u0003\u0002F!I\u0011Q\n\u0005C\u0002\u0013\u0005\u00111\t\u0005\t\u0003\u001fB\u0001\u0015!\u0003\u0002F!I\u0011\u0011\u000b\u0005C\u0002\u0013\u0005\u00111\t\u0005\t\u0003'B\u0001\u0015!\u0003\u0002F!I\u0011Q\u000b\u0005C\u0002\u0013\u0005\u00111\t\u0005\t\u0003/B\u0001\u0015!\u0003\u0002F!I\u0011\u0011\f\u0005C\u0002\u0013\u0005\u00111\t\u0005\t\u00037B\u0001\u0015!\u0003\u0002F!I\u0011Q\f\u0005C\u0002\u0013\u0005\u00111\t\u0005\t\u0003?B\u0001\u0015!\u0003\u0002F\u00191\u0011\u0011M\u0001\u0005\u0003GB\u0011\"!\u0005\u001a\u0005\u0003\u0005\u000b\u0011\u0002/\t\r=KB\u0011AAU\u0011\u00159\u0017\u0004\"\u0011i\u0011\u0015q\u0018\u0004\"\u0011\u0000\u0011\u0015Q\u0016\u0004\"\u0011\\\r\u0019\ty+\u0001\u0003\u00022\"A!l\bBC\u0002\u0013\u00053\fC\u0005\u00024~\u0011\t\u0011)A\u00059\"I\u00111D\u0010\u0003\u0002\u0003\u0006I\u0001\u0018\u0005\u0007\u001f~!\t!!.\t\u000b\u001d|B\u0011\t5\t\u000bE|B\u0011I.\t\u000by|B\u0011I@\u0007\r\u0005u\u0016\u0001BA`\u0011!QvE!b\u0001\n\u0003Z\u0006\"CAZO\t\u0005\t\u0015!\u0003]\u0011%\t\tm\nB\u0001B\u0003%\u0011\u000e\u0003\u0004PO\u0011\u0005\u00111\u0019\u0005\u0006O\u001e\"\t\u0005\u001b\u0005\b\u0003_:C\u0011KAf\r\u0019\ty.\u0001\u0003\u0002b\"Q\u00111\u0001\u0018\u0003\u0002\u0003\u0006I!!\u0002\t\r=sC\u0011AAr\u0011\u00159g\u0006\"\u0011i\u0011\u0015Qf\u0006\"\u0011\\\r%\t9'\u0001I\u0001\u0004\u0013\tI\u0007C\u0003Vg\u0011\u0005a\u000bC\u0003rg\u0011\u00053\f\u0003\u0004sg\u0011\u0005\u00131\u000e\u0005\b\u0003_\u001aD\u0011CA9\r\u001d9\u0005\t%A\u0002\u0002QCQ!\u0016\u001d\u0005\u0002YCQA\u0017\u001d\u0007\u0002mCQa\u001a\u001d\u0007\u0002!DQ!\u001d\u001d\u0007\u0002mCQA\u001d\u001d\u0007\u0002MDQA \u001d\u0005\u0002}\f1BU3t_V\u00148-\u001a\"pq*\u0011\u0011IQ\u0001\u0007aV\u0004\b/\u001a;\u000b\u0003\r\u000bqa^3dQ\u0006$\u0018p\u0001\u0001\u0011\u0005\u0019\u000bQ\"\u0001!\u0003\u0017I+7o\\;sG\u0016\u0014u\u000e_\n\u0003\u0003%\u0003\"AS'\u000e\u0003-S\u0011\u0001T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001d.\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001F\u0003!1'o\\7GS2,GcA*\u0002\u0002A\u0011a\tO\n\u0003q%\u000ba\u0001J5oSR$C#A,\u0011\u0005)C\u0016BA-L\u0005\u0011)f.\u001b;\u0002\t9\fW.Z\u000b\u00029B\u0011Q\f\u001a\b\u0003=\n\u0004\"aX&\u000e\u0003\u0001T!!\u0019#\u0002\rq\u0012xn\u001c;?\u0013\t\u00197*\u0001\u0004Qe\u0016$WMZ\u0005\u0003K\u001a\u0014aa\u0015;sS:<'BA2L\u0003!!xn\u0015;sK\u0006lW#A5\u0011\u0005)|W\"A6\u000b\u00051l\u0017AA5p\u0015\u0005q\u0017\u0001\u00026bm\u0006L!\u0001]6\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\\\u0001\ti>\u0014\u0015m]37i\u0005IAo\u001c#bi\u0006,&\u000b\u0014\u000b\u00039RDQ!^\u001fA\u0002Y\f\u0001\"\\5nKRK\b/\u001a\t\u0003orl\u0011\u0001\u001f\u0006\u0003sj\f!\"Y2uSZ\fG/[8o\u0015\u0005Y\u0018!\u00026bm\u0006D\u0018BA?y\u0005!i\u0015.\\3UsB,\u0017A\u0002;p\u0015N|g\u000eF\u0001]\u0011\u001d\t\u0019a\u0001a\u0001\u0003\u000b\tAAZ5mKB\u0019!.a\u0002\n\u0007\u0005%1N\u0001\u0003GS2,\u0017a\u00024s_6,&\u000f\u001c\u000b\u0004'\u0006=\u0001BBA\t\t\u0001\u0007A,A\u0002ve2\f!B\u001a:p[\n\u000b7/\u001a\u001c5)\u0015\u0019\u0016qCA\r\u0011\u0015QV\u00011\u0001]\u0011\u0019\tY\"\u0002a\u00019\u00061!-Y:fmQ\n\u0001B\u001a:p[*\u001bxN\u001c\u000b\u0004'\u0006\u0005\u0002BBA\u0012\r\u0001\u0007A,\u0001\u0003kg>t\u0017a\u0004*fg>,(oY3C_b$\u0016\u0010]3\u0011\u0007\u0005%\u0002\"D\u0001\u0002\u0005=\u0011Vm]8ve\u000e,'i\u001c=UsB,7c\u0001\u0005\u00020A\u0019!*!\r\n\u0007\u0005M2JA\u0006F]VlWM]1uS>tGCAA\u0014\u0005\u0011!\u0016\u0010]3\u0011\t\u0005m\u0012QH\u0007\u0002\u0011%!\u0011qHA\u0019\u0005\u00151\u0016\r\\;f\u0003\u001d)fn\u001b8po:,\"!!\u0012\u0011\u0007\u0005m\"\"\u0001\u0005V].twn\u001e8!\u0003\u0019\u0011\u0015m]37i\u00059!)Y:fmQ\u0002\u0013aA+sY\u0006!QK\u001d7!\u0003\u0019\t&kQ8eK\u00069\u0011KU\"pI\u0016\u0004\u0013A\u0002\"vM\u001a,'/A\u0004Ck\u001a4WM\u001d\u0011\u0002\t\u0019KG.Z\u0001\u0006\r&dW\rI\u0001\u0007'R\u0014X-Y7\u0002\u000fM#(/Z1nA\tqQK\u001d7SKN|WO]2f\u0005>D8\u0003B\rJ\u0003K\u00022!!\u000b4\u0005M\t%m\u001d;sC\u000e$(+Z:pkJ\u001cWMQ8y'\r\u0019\u0014j\u0015\u000b\u00049\u00065\u0004\"B;7\u0001\u00041\u0018!B;tS:<WCBA:\u00033\u000bY\b\u0006\u0003\u0002v\u0005\u0015F\u0003BA<\u0003\u001b\u0003B!!\u001f\u0002|1\u0001AaBA?o\t\u0007\u0011q\u0010\u0002\u0002%F!\u0011\u0011QAD!\rQ\u00151Q\u0005\u0004\u0003\u000b[%a\u0002(pi\"Lgn\u001a\t\u0004\u0015\u0006%\u0015bAAF\u0017\n\u0019\u0011I\\=\t\u000f\u0005=u\u00071\u0001\u0002\u0012\u0006)!\r\\8dWB9!*a%\u0002\u0018\u0006]\u0014bAAK\u0017\nIa)\u001e8di&|g.\r\t\u0005\u0003s\nI\nB\u0004\u0002\u001c^\u0012\r!!(\u0003\u0003Q\u000bB!!!\u0002 B\u0019!.!)\n\u0007\u0005\r6NA\u0005DY>\u001cX-\u00192mK\"9\u0011qU\u001cA\u0002\u0005]\u0015\u0001\u0003:fg>,(oY3\u0015\t\u0005-\u0016Q\u0016\t\u0004\u0003SI\u0002BBA\t7\u0001\u0007ALA\tCCN,g\u0007\u000e*fg>,(oY3C_b\u001cBaH%\u0002f\u0005)a.Y7fAQ1\u0011qWA]\u0003w\u00032!!\u000b \u0011\u0015Q6\u00051\u0001]\u0011\u0019\tYb\ta\u00019\n\t2\u000b\u001e:fC6\u0014Vm]8ve\u000e,'i\u001c=\u0014\t\u001dJ\u0015QM\u0001\u0007gR\u0014X-Y7\u0015\r\u0005\u0015\u0017qYAe!\r\tIc\n\u0005\u00065.\u0002\r\u0001\u0018\u0005\u0007\u0003\u0003\\\u0003\u0019A5\u0016\r\u00055\u00171\\Aj)\u0011\ty-!8\u0015\t\u0005E\u0017Q\u001b\t\u0005\u0003s\n\u0019\u000eB\u0004\u0002~5\u0012\r!a \t\u000f\u0005=U\u00061\u0001\u0002XB9!*a%\u0002Z\u0006E\u0007\u0003BA=\u00037$q!a'.\u0005\u0004\ti\nC\u0004\u0002(6\u0002\r!!7\u0003\u001f\u0019KG.\u001a*fg>,(oY3C_b\u001cBAL%\u0002fQ!\u0011Q]At!\r\tIC\f\u0005\b\u0003\u0007\u0001\u0004\u0019AA\u0003\u0001")
public interface ResourceBox {
    public static ResourceBox fromJson(String string) {
        return ResourceBox$.MODULE$.fromJson(string);
    }

    public static ResourceBox fromBase64(String string, String string2) {
        return ResourceBox$.MODULE$.fromBase64(string, string2);
    }

    public static ResourceBox fromUrl(String string) {
        return ResourceBox$.MODULE$.fromUrl(string);
    }

    public static ResourceBox fromFile(File file) {
        return ResourceBox$.MODULE$.fromFile(file);
    }

    public String name();

    public InputStream toStream();

    public String toBase64();

    public String toDataURL(MimeType var1);

    default public String toJson() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public static void $init$(ResourceBox $this) {
    }

    public static interface AbstractResourceBox
    extends ResourceBox {
        @Override
        default public String toBase64() {
            return (String)this.using(this.toStream(), (Function1 & Serializable & scala.Serializable)fi -> {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                OutputStream base64Out = Base64.getEncoder().wrap(byteArrayOutputStream);
                IOUtils.copy((InputStream)fi, (OutputStream)base64Out);
                base64Out.close();
                byteArrayOutputStream.close();
                return byteArrayOutputStream.toString();
            });
        }

        @Override
        default public String toDataURL(MimeType mimeType) {
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(new Object[]{"data:", mimeType, ";base64,", this.toBase64()})).mkString("");
        }

        default public <T extends Closeable, R> R using(T resource, Function1<T, R> block) {
            Object object;
            try {
                object = block.apply(resource);
            }
            finally {
                if (resource != null) {
                    resource.close();
                }
            }
            return (R)object;
        }

        public static void $init$(AbstractResourceBox $this) {
        }
    }

    public static class Base64ResourceBox
    implements AbstractResourceBox {
        private final String name;
        private final String base64;

        @Override
        public String toDataURL(MimeType mimeType) {
            return ((AbstractResourceBox)this).toDataURL(mimeType);
        }

        @Override
        public <T extends Closeable, R> R using(T resource, Function1<T, R> block) {
            return (R)((AbstractResourceBox)this).using(resource, block);
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public InputStream toStream() {
            return new ByteArrayInputStream(Base64.getDecoder().decode(this.base64));
        }

        @Override
        public String toBase64() {
            return this.base64;
        }

        @Override
        public String toJson() {
            ObjectNode objectNode = Puppet$.MODULE$.objectMapper().createObjectNode();
            objectNode.put("name", this.name());
            objectNode.put("boxType", ResourceBox$ResourceBoxType$.MODULE$.Base64().id());
            objectNode.put("base64", this.base64);
            return objectNode.toString();
        }

        public Base64ResourceBox(String name, String base64) {
            this.name = name;
            this.base64 = base64;
            ResourceBox.$init$(this);
            AbstractResourceBox.$init$(this);
        }
    }

    public static class FileResourceBox
    implements AbstractResourceBox {
        private final File file;

        @Override
        public String toBase64() {
            return ((AbstractResourceBox)this).toBase64();
        }

        @Override
        public String toDataURL(MimeType mimeType) {
            return ((AbstractResourceBox)this).toDataURL(mimeType);
        }

        @Override
        public <T extends Closeable, R> R using(T resource, Function1<T, R> block) {
            return (R)((AbstractResourceBox)this).using(resource, block);
        }

        @Override
        public String toJson() {
            return ((ResourceBox)this).toJson();
        }

        @Override
        public InputStream toStream() {
            return new FileInputStream(this.file);
        }

        @Override
        public String name() {
            return this.file.getName();
        }

        public FileResourceBox(File file) {
            this.file = file;
            ResourceBox.$init$(this);
            AbstractResourceBox.$init$(this);
        }
    }

    public static class StreamResourceBox
    implements AbstractResourceBox {
        private final String name;
        private final InputStream stream;

        @Override
        public String toBase64() {
            return ((AbstractResourceBox)this).toBase64();
        }

        @Override
        public String toDataURL(MimeType mimeType) {
            return ((AbstractResourceBox)this).toDataURL(mimeType);
        }

        @Override
        public String toJson() {
            return ((ResourceBox)this).toJson();
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public InputStream toStream() {
            return this.stream;
        }

        @Override
        public <T extends Closeable, R> R using(T resource, Function1<T, R> block) {
            return (R)block.apply(resource);
        }

        public StreamResourceBox(String name, InputStream stream) {
            this.name = name;
            this.stream = stream;
            ResourceBox.$init$(this);
            AbstractResourceBox.$init$(this);
        }
    }

    public static class UrlResourceBox
    implements AbstractResourceBox {
        private final String url;

        @Override
        public String toBase64() {
            return ((AbstractResourceBox)this).toBase64();
        }

        @Override
        public String toDataURL(MimeType mimeType) {
            return ((AbstractResourceBox)this).toDataURL(mimeType);
        }

        @Override
        public <T extends Closeable, R> R using(T resource, Function1<T, R> block) {
            return (R)((AbstractResourceBox)this).using(resource, block);
        }

        @Override
        public InputStream toStream() {
            HttpURLConnection connection = (HttpURLConnection)new URL(this.url).openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setRequestMethod("GET");
            connection.setRequestProperty("User-Agent", "wechaty/scala");
            return connection.getInputStream();
        }

        @Override
        public String toJson() {
            ObjectNode objectNode = Puppet$.MODULE$.objectMapper().createObjectNode();
            objectNode.put("name", this.name());
            objectNode.put("boxType", ResourceBox$ResourceBoxType$.MODULE$.Url().id());
            objectNode.put("remoteUrl", this.url);
            return objectNode.toString();
        }

        @Override
        public String name() {
            return this.url.substring(this.url.lastIndexOf("/") + 1);
        }

        public UrlResourceBox(String url) {
            this.url = url;
            ResourceBox.$init$(this);
            AbstractResourceBox.$init$(this);
        }
    }
}

