/*
 * Decompiled with CFR 0.152.
 */
package io.github.quickmsg.source.db;

import io.github.quickmsg.common.rule.source.Source;
import io.github.quickmsg.common.rule.source.SourceBean;
import io.github.quickmsg.source.db.config.HikariCPConnectionProvider;
import java.sql.Connection;
import java.util.Map;
import java.util.Properties;
import org.jooq.DSLContext;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbSourceBean
implements SourceBean {
    private static final Logger log = LoggerFactory.getLogger(DbSourceBean.class);

    public Boolean support(Source source) {
        return source == Source.DATA_BASE;
    }

    public Boolean bootstrap(Map<String, Object> sourceParam) {
        Properties properties = new Properties();
        for (String key : sourceParam.keySet()) {
            properties.put(key.replaceAll("-", "."), sourceParam.get(key).toString());
        }
        try {
            HikariCPConnectionProvider.singleTon().init(properties);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void transmit(Map<String, Object> object) {
        try (Connection connection = HikariCPConnectionProvider.singleTon().getConnection();){
            DSLContext dslContext = DSL.using((Connection)connection);
            dslContext.execute(object.get("sql").toString());
        }
        catch (Exception e) {
            log.error("execute sql error", (Throwable)e);
        }
    }

    public void close() {
        HikariCPConnectionProvider.singleTon().shutdown();
    }
}

