/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.config;

import io.github.pnoker.common.entity.bo.AuthInfoBO;
import io.github.pnoker.common.utils.RequestUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.NonNull;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@EnableWebMvc
@Configuration
public class WebMvcConfig
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(WebMvcConfig.class);

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/favicon.ico"}).addResourceLocations(new String[]{"classpath:/static/"});
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(new HandlerInterceptor(){

            public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) throws Exception {
                AuthInfoBO authInfo = WebMvcConfig.this.getAuthInfo(request);
                RequestUtil.setAuthInfo(authInfo);
                return super.preHandle(request, response, handler);
            }

            public void postHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler, ModelAndView modelAndView) throws Exception {
                super.postHandle(request, response, handler, modelAndView);
            }

            public void afterCompletion(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler, Exception ex) throws Exception {
                RequestUtil.resetAuthInfo();
                super.afterCompletion(request, response, handler, ex);
            }
        });
    }

    private AuthInfoBO getAuthInfo(HttpServletRequest request) {
        String tenantId = RequestUtil.getRequestHeader(request, "X-Auth-Tenant-Id");
        String tenantName = RequestUtil.getRequestHeader(request, "X-Auth-Tenant");
        String userId = RequestUtil.getRequestHeader(request, "X-Auth-User-Id");
        String nickName = RequestUtil.getRequestHeader(request, "X-Auth-Nick");
        String userName = RequestUtil.getRequestHeader(request, "X-Auth-User");
        return new AuthInfoBO(tenantId, tenantName, userId, nickName, userName);
    }
}

