/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.config;

import io.github.pnoker.common.entity.R;
import io.github.pnoker.common.exception.UnAuthorizedException;
import io.github.pnoker.common.utils.JsonUtil;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionConfig {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionConfig.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public R<String> globalException(Exception exception) {
        log.error("Global Exception Handler: {}", (Object)exception.getMessage(), (Object)exception);
        return R.fail((String)exception.getMessage());
    }

    @ExceptionHandler(value={UnAuthorizedException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public R<String> unAuthorizedException(UnAuthorizedException unAuthorizedException) {
        log.warn("UnAuthorized Exception Handler: {}", (Object)unAuthorizedException.getMessage(), (Object)unAuthorizedException);
        return R.fail((String)unAuthorizedException.getMessage());
    }

    @ExceptionHandler(value={BindException.class, MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.PRECONDITION_FAILED)
    public R<String> methodArgumentNotValidException(MethodArgumentNotValidException exception) {
        HashMap map = new HashMap(16);
        List errorList = exception.getBindingResult().getFieldErrors();
        errorList.forEach(error -> {
            log.warn("Method Argument Not Valid Exception Handler: {}({})", (Object)error.getField(), (Object)error.getDefaultMessage());
            map.put(error.getField(), error.getDefaultMessage());
        });
        return R.fail((String)JsonUtil.toJsonString(map));
    }
}

