/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.utils;

import cn.hutool.core.util.ObjectUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509Util {
    private static final Logger log = LoggerFactory.getLogger(X509Util.class);

    private X509Util() {
        throw new IllegalStateException("Utility class");
    }

    public static SSLSocketFactory getSSLSocketFactory(String caCrtFile, String crtFile, String keyFile, String password) {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            X509Certificate caCert = (X509Certificate)X509Util.loadCertificate(caCrtFile);
            KeyStore caKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            caKeyStore.load(null, null);
            caKeyStore.setCertificateEntry("cacertfile", caCert);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(caKeyStore);
            X509Certificate cert = (X509Certificate)X509Util.loadCertificate(crtFile);
            KeyPair key = (KeyPair)X509Util.loadCertificateWithPassword(keyFile, password);
            KeyStore certKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            certKeyStore.load(null, null);
            certKeyStore.setCertificateEntry("certfile", cert);
            certKeyStore.setKeyEntry("keyfile", key.getPrivate(), password.toCharArray(), new Certificate[]{cert});
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(certKeyStore, password.toCharArray());
            SSLContext context = SSLContext.getInstance("TLSv1.2");
            context.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            return context.getSocketFactory();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private static <T> T loadCertificate(String caCrtFile) throws IOException {
        return X509Util.loadCertificateWithPassword(caCrtFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T loadCertificateWithPassword(String caCrtFile, String password) throws IOException {
        PEMReader reader = null;
        try {
            String classPath = "classpath:";
            reader = caCrtFile.startsWith(classPath) ? (ObjectUtil.isNotNull((Object)password) ? new PEMReader((Reader)new InputStreamReader(X509Util.class.getResourceAsStream(caCrtFile.replace(classPath, ""))), password::toCharArray) : new PEMReader((Reader)new InputStreamReader(X509Util.class.getResourceAsStream(caCrtFile.replace(classPath, ""))))) : (ObjectUtil.isNotNull((Object)password) ? new PEMReader((Reader)new InputStreamReader(new ByteArrayInputStream(Files.readAllBytes(Paths.get(caCrtFile, new String[0])))), password::toCharArray) : new PEMReader((Reader)new InputStreamReader(new ByteArrayInputStream(Files.readAllBytes(Paths.get(caCrtFile, new String[0]))))));
            Object object = reader.readObject();
            return (T)object;
        }
        finally {
            if (ObjectUtil.isNotNull((Object)reader)) {
                reader.close();
            }
        }
    }
}

